/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.jade_vines;

import earth.terrarium.pastel.blocks.jade_vines.JadeVine;
import earth.terrarium.pastel.blocks.jade_vines.JadeVineRootsBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class GerminatedJadeVineBulbItem
extends Item {
    public GerminatedJadeVineBulbItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        if (JadeVineRootsBlock.canBePlantedOn(world.getBlockState(pos = context.getClickedPos())) && world.getBlockState(pos.below()).isAir()) {
            if (context.getLevel().isClientSide) {
                for (int i = 0; i < 16; ++i) {
                    JadeVine.spawnParticlesClient(world, pos);
                    JadeVine.spawnParticlesClient(world, pos.below());
                }
                return InteractionResult.SUCCESS;
            }
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            world.setBlockAndUpdate(pos, ((Block)PastelBlocks.JADE_VINE_ROOTS.get()).defaultBlockState());
            BlockState bulbState = ((Block)PastelBlocks.JADE_VINE_BULB.get()).defaultBlockState();
            world.setBlockAndUpdate(pos.below(), bulbState);
            world.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.PLAYERS, 1.0f, 1.0f);
            SoundType blockSoundGroup = bulbState.getSoundType();
            world.playSound((Player)player, pos.below(), bulbState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, (blockSoundGroup.getVolume() + 1.0f) / 2.0f, blockSoundGroup.getPitch() * 0.8f);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos.below());
            CriteriaTriggers.PLACED_BLOCK.trigger(player, pos, context.getItemInHand());
            CriteriaTriggers.PLACED_BLOCK.trigger(player, pos.below(), context.getItemInHand());
            if (player == null || !player.isCreative()) {
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.germinated_jade_vine_bulb.tooltip"));
        tooltip.add((Component)Component.translatable((String)"item.pastel.germinated_jade_vine_bulb.tooltip2"));
        tooltip.add((Component)Component.translatable((String)"item.pastel.germinated_jade_vine_bulb.tooltip3"));
    }
}

