/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.mixin.accessors.SlimeEntityAccessor;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.progression.PastelCriteria;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SlimeSizingIdolBlock
extends IdolBlock {
    protected final int maxSize;
    protected final int range;

    public SlimeSizingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, int range, int maxSize) {
        super(settings, particleEffect);
        this.range = range;
        this.maxSize = maxSize;
    }

    public MapCodec<? extends SlimeSizingIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.slime_sizing_idol.tooltip"));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        int boxSize = this.range + this.range;
        List slimeEntities = world.getEntitiesOfClass(Slime.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize));
        for (Slime slimeEntity : slimeEntities) {
            if (slimeEntity.getSize() >= this.maxSize) continue;
            int newSize = slimeEntity.getSize() + 1;
            ((SlimeEntityAccessor)slimeEntity).invokeSetSize(newSize, true);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, Vec3.atCenterOf((Vec3i)blockPos), ((SlimeEntityAccessor)slimeEntity).invokeGetParticleType(), 16, new Vec3(0.75, 0.75, 0.75), new Vec3(0.1, 0.1, 0.1));
            AABB boundingBox = slimeEntity.getBoundingBox();
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, slimeEntity.position().add(0.0, boundingBox.getYsize() / 2.0, 0.0), ((SlimeEntityAccessor)slimeEntity).invokeGetParticleType(), newSize * 8, new Vec3(boundingBox.getXsize(), boundingBox.getYsize(), boundingBox.getZsize()), new Vec3(0.1, 0.1, 0.1));
            slimeEntity.playSound(((SlimeEntityAccessor)slimeEntity).invokeGetSquishSound(), ((SlimeEntityAccessor)slimeEntity).invokeGetSoundVolume(), ((world.random.nextFloat() - world.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                PastelCriteria.SLIME_SIZING.trigger(serverPlayerEntity, newSize);
            }
            return true;
        }
        return true;
    }
}

