/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectileIdolBlock
extends IdolBlock {
    protected final EntityType<?> entityType;
    protected final SoundEvent triggerSoundEvent;
    protected final float speed;
    protected final float divergence;

    public ProjectileIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, EntityType<?> entityType, SoundEvent triggerSoundEvent, float speed, float divergence) {
        super(settings, particleEffect);
        this.entityType = entityType;
        this.triggerSoundEvent = triggerSoundEvent;
        this.speed = speed;
        this.divergence = divergence;
    }

    public MapCodec<? extends ProjectileIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.projectile_idol.tooltip", (Object[])new Object[]{this.entityType.getDescription()}));
    }

    @Override
    public boolean trigger(@NotNull ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        BlockPos outputBlockPos = blockPos.relative(side = side.getOpposite());
        if (world.getBlockState(outputBlockPos).getCollisionShape((BlockGetter)world, outputBlockPos).isEmpty()) {
            Vec3 outputLocation = this.getOutputLocation(blockPos, side);
            Projectile projectileEntity = this.createProjectile(world, blockPos, (Position)outputLocation, side);
            projectileEntity.shoot((double)side.getStepX(), (double)side.getStepY(), (double)side.getStepZ(), this.speed, this.divergence);
            world.addFreshEntity((Entity)projectileEntity);
            world.playSound(null, blockPos, this.triggerSoundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public abstract Projectile createProjectile(ServerLevel var1, BlockPos var2, Position var3, Direction var4);

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityShapeContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityShapeContext = (EntityCollisionContext)context).getEntity()) != null && entity.getType() == this.entityType && entity.tickCount < 2) {
            return Shapes.empty();
        }
        return state.getShape(world, pos);
    }
}

