/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PiglinTradeIdolBlock
extends IdolBlock {
    public PiglinTradeIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect) {
        super(settings, particleEffect);
    }

    public MapCodec<? extends PiglinTradeIdolBlock> codec() {
        return null;
    }

    private static List<ItemStack> getBarteredStacks(@NotNull ServerLevel world, BlockPos blockPos) {
        Piglin piglin = new Piglin(EntityType.PIGLIN, (Level)world);
        piglin.setPosRaw((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList loot = lootTable.getRandomItems(new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, (Object)piglin).create(LootContextParamSets.PIGLIN_BARTER));
        piglin.discard();
        return loot;
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.getItem();
            if (stack.is(PiglinAi.BARTERING_ITEM)) {
                int newAmount = stack.getCount() - 1;
                if (newAmount <= 0) {
                    itemEntity.discard();
                } else {
                    stack.shrink(1);
                }
                this.outputLoot(world, blockPos, side);
                return true;
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack handStack : player.getHandSlots()) {
                if (!handStack.is(PiglinAi.BARTERING_ITEM)) continue;
                handStack.shrink(1);
                this.outputLoot(world, blockPos, side);
                return true;
            }
        }
        return false;
    }

    private void outputLoot(ServerLevel world, BlockPos blockPos, Direction side) {
        Vec3 outputLocation = this.getOutputLocation(blockPos, side);
        for (ItemStack barteredStack : PiglinTradeIdolBlock.getBarteredStacks(world, blockPos)) {
            ItemEntity itemEntity = new ItemEntity((Level)world, outputLocation.x(), outputLocation.y(), outputLocation.z(), barteredStack);
            itemEntity.push((double)side.getStepX() * 0.25, (double)side.getStepY() * 0.25 + 0.03, (double)side.getStepZ() * 0.25);
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.piglin_trade_idol.tooltip"));
    }
}

