/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.blocks.idols.RandomTeleportingIdolBlock;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineTeleportingIdolBlock
extends IdolBlock {
    protected final int range;

    public LineTeleportingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, int range) {
        super(settings, particleEffect);
        this.range = range;
    }

    public MapCodec<? extends LineTeleportingIdolBlock> codec() {
        return null;
    }

    public static Direction getLookDirection(@NotNull Entity entity, boolean mirrorVertical, boolean mirrorHorizontal) {
        double pitch = entity.getXRot();
        if (pitch < -60.0) {
            return mirrorVertical ? Direction.UP : Direction.DOWN;
        }
        if (pitch > 60.0) {
            return mirrorVertical ? Direction.DOWN : Direction.UP;
        }
        return mirrorHorizontal ? entity.getMotionDirection().getOpposite() : entity.getMotionDirection();
    }

    public static Optional<BlockPos> searchForBlock(Level world, BlockPos pos, BlockState searchedState, Direction direction, int range) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int i = 1; i < range; ++i) {
            BlockPos currPos = mutable.relative(direction, i);
            if (world.getBlockState(currPos) != searchedState) continue;
            return Optional.of(currPos);
        }
        return Optional.empty();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.line_teleporting_idol.tooltip", (Object[])new Object[]{this.range}));
        tooltip.add((Component)Component.translatable((String)"block.pastel.line_teleporting_idol.tooltip2", (Object[])new Object[]{this.range}));
    }

    @Override
    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!world.isClientSide && !this.hasCooldown(state) && this.trigger((ServerLevel)world, pos, state, entity, LineTeleportingIdolBlock.getLookDirection(entity, true, false).getOpposite())) {
            this.playTriggerParticles((ServerLevel)world, pos);
            this.playTriggerSound(world, pos);
            this.triggerCooldown(world, pos);
        }
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        Optional<BlockPos> foundBlockPos;
        if (entity != null && (foundBlockPos = LineTeleportingIdolBlock.searchForBlock((Level)world, blockPos, state, side.getOpposite(), this.range)).isPresent()) {
            BlockPos targetPos = foundBlockPos.get();
            this.triggerCooldown((Level)world, targetPos);
            RandomTeleportingIdolBlock.teleportTo(world, entity, targetPos);
            return true;
        }
        return false;
    }

    @Override
    public int getCooldownTicks() {
        return 10;
    }
}

