/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InsomniaIdolBlock
extends IdolBlock {
    public final int additionalTicksSinceLastRest;

    public InsomniaIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, int additionalTicksSinceLastRest) {
        super(settings, particleEffect);
        this.additionalTicksSinceLastRest = additionalTicksSinceLastRest;
    }

    public MapCodec<? extends InsomniaIdolBlock> codec() {
        return null;
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        if (entity instanceof ServerPlayer) {
            Phantom phantomEntity;
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            RandomSource random = world.random;
            world.playSound(null, blockPos, SoundEvents.PHANTOM_AMBIENT, SoundSource.BLOCKS, 1.0f, 0.8f + random.nextFloat() * 0.4f);
            int currentStatValue = serverPlayerEntity.getStats().getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
            int newValue = Mth.clamp((int)currentStatValue, (int)0, (int)(Integer.MAX_VALUE - this.additionalTicksSinceLastRest)) + this.additionalTicksSinceLastRest;
            serverPlayerEntity.getStats().setValue((Player)serverPlayerEntity, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), newValue);
            if (world.canSeeSky(blockPos.above()) && TimeHelper.getTimeOfDay((Level)world).isNight() && (phantomEntity = (Phantom)EntityType.PHANTOM.create((Level)world)) != null) {
                phantomEntity.moveTo(blockPos.above(20 + random.nextInt(15)).east(-10 + random.nextInt(21)).south(-10 + random.nextInt(21)), 0.0f, 0.0f);
                phantomEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(blockPos), MobSpawnType.MOB_SUMMONED, null);
                int phantomSize = Math.min(64, newValue / 24000);
                phantomEntity.setPhantomSize(phantomSize);
                world.addFreshEntityWithPassengers((Entity)phantomEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getCooldownTicks() {
        return 200;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.insomnia_idol.tooltip"));
    }
}

