/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreezingIdolBlock
extends IdolBlock {
    public static final Map<Block, Tuple<BlockState, Float>> FREEZING_MAP = new HashMap<Block, Tuple<BlockState, Float>>(){
        {
            this.put(Blocks.SNOW, new Tuple((Object)Blocks.POWDER_SNOW.defaultBlockState(), (Object)Float.valueOf(0.25f)));
            this.put(Blocks.POWDER_SNOW, new Tuple((Object)Blocks.SNOW_BLOCK.defaultBlockState(), (Object)Float.valueOf(0.5f)));
            this.put(Blocks.WATER, new Tuple((Object)Blocks.ICE.defaultBlockState(), (Object)Float.valueOf(1.0f)));
            this.put(Blocks.ICE, new Tuple((Object)Blocks.PACKED_ICE.defaultBlockState(), (Object)Float.valueOf(0.25f)));
            this.put(Blocks.PACKED_ICE, new Tuple((Object)Blocks.BLUE_ICE.defaultBlockState(), (Object)Float.valueOf(0.1f)));
            this.put(Blocks.GRASS_BLOCK, new Tuple((Object)Blocks.PODZOL.defaultBlockState(), (Object)Float.valueOf(0.1f)));
            this.put(Blocks.BASALT, new Tuple((Object)Blocks.CALCITE.defaultBlockState(), (Object)Float.valueOf(0.5f)));
            this.put((Block)PastelBlocks.BLAZING_CRYSTAL.get(), new Tuple((Object)((Block)PastelBlocks.FROSTBITE_CRYSTAL.get()).defaultBlockState(), (Object)Float.valueOf(0.5f)));
        }
    };
    public static final Map<BlockState, Tuple<BlockState, Float>> FREEZING_STATE_MAP = new HashMap<BlockState, Tuple<BlockState, Float>>(){
        {
            this.put(Blocks.LAVA.defaultBlockState(), new Tuple((Object)Blocks.OBSIDIAN.defaultBlockState(), (Object)Float.valueOf(1.0f)));
        }
    };

    public FreezingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect) {
        super(settings, particleEffect);
    }

    public MapCodec<? extends FreezingIdolBlock> codec() {
        return null;
    }

    public static void freeze(@NotNull ServerLevel world, BlockPos blockPos) {
        Tuple<BlockState, Float> recipe;
        BlockState sourceState = world.getBlockState(blockPos);
        if (FREEZING_MAP.containsKey(sourceState.getBlock()) && (((Float)(recipe = FREEZING_MAP.get(sourceState.getBlock())).getB()).floatValue() >= 1.0f || world.random.nextFloat() < ((Float)recipe.getB()).floatValue())) {
            world.setBlockAndUpdate(blockPos, (BlockState)recipe.getA());
            world.levelEvent(2001, blockPos, Block.getId((BlockState)((BlockState)recipe.getA())));
            return;
        }
        if (FREEZING_STATE_MAP.containsKey(sourceState) && (((Float)(recipe = FREEZING_STATE_MAP.get(sourceState)).getB()).floatValue() >= 1.0f || world.random.nextFloat() < ((Float)recipe.getB()).floatValue())) {
            world.setBlockAndUpdate(blockPos, (BlockState)recipe.getA());
            world.levelEvent(2001, blockPos, Block.getId((BlockState)((BlockState)recipe.getA())));
        }
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        for (Direction direction : Direction.values()) {
            FreezingIdolBlock.freeze(world, blockPos.relative(direction));
        }
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.freezing_idol.tooltip"));
    }
}

