/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import earth.terrarium.pastel.helpers.interaction.InWorldInteractionHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FeedingIdolBlock
extends IdolBlock {
    protected static final int LOVE_TICKS = 600;
    protected final int range;

    public FeedingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect, int range) {
        super(settings, particleEffect);
        this.range = range;
    }

    public MapCodec<? extends FeedingIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.feeding_idol.tooltip", (Object[])new Object[]{this.range}));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        ItemStack stack;
        int boxSize = this.range + this.range;
        AABB box = AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)blockPos), (double)boxSize, (double)boxSize, (double)boxSize);
        List animalEntities = world.getEntitiesOfClass(Animal.class, box);
        List itemEntities = world.getEntitiesOfClass(ItemEntity.class, box);
        for (Animal animalEntity : animalEntities) {
            if (animalEntity.getAge() != 0 || animalEntity.isInLove()) continue;
            for (ItemEntity itemEntity : itemEntities) {
                stack = itemEntity.getItem();
                if (!animalEntity.isFood(stack)) continue;
                InWorldInteractionHelper.decrementAndSpawnRemainder(itemEntity, 1);
                animalEntity.setInLoveTime(600);
                world.broadcastEntityEvent((Entity)animalEntity, (byte)18);
            }
        }
        for (Animal animalEntity : animalEntities) {
            if (!animalEntity.isBaby()) continue;
            for (ItemEntity itemEntity : itemEntities) {
                stack = itemEntity.getItem();
                if (!animalEntity.isFood(stack)) continue;
                InWorldInteractionHelper.decrementAndSpawnRemainder(itemEntity, 1);
                animalEntity.ageUp((int)((float)(-animalEntity.getAge() / 20) * 0.1f), true);
                animalEntity.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            }
        }
        return true;
    }
}

