/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FallDamageNegatingIdolBlock
extends IdolBlock {
    public FallDamageNegatingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect) {
        super(settings, particleEffect);
    }

    public MapCodec<? extends FallDamageNegatingIdolBlock> codec() {
        return null;
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        if (entity != null && entity.getDeltaMovement().y() < -0.01) {
            entity.setDeltaMovement(0.0, 0.5, 0.0);
            entity.hurtMarked = true;
            entity.hasImpulse = true;
            entity.fallDistance = 0.0f;
            return true;
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.fall_damage_negating_idol.tooltip"));
        tooltip.add((Component)Component.translatable((String)"block.pastel.fall_damage_negating_idol.tooltip2"));
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!this.hasCooldown(state) && fallDistance > 3.0f) {
            entity.causeFallDamage(fallDistance, 0.0f, world.damageSources().fall());
            if (!world.isClientSide) {
                this.playTriggerParticles((ServerLevel)world, pos);
                this.playTriggerSound(world, pos);
                this.triggerCooldown(world, pos);
            }
        }
    }
}

