/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.idols;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.idols.IdolBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BonemealingIdolBlock
extends IdolBlock {
    public BonemealingIdolBlock(BlockBehaviour.Properties settings, ParticleOptions particleEffect) {
        super(settings, particleEffect);
    }

    public MapCodec<? extends BonemealingIdolBlock> codec() {
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.bonemealing_idol.tooltip"));
    }

    @Override
    public boolean trigger(ServerLevel world, BlockPos blockPos, BlockState state, @Nullable Entity entity, Direction side) {
        int startDirection = world.random.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            BonemealableBlock fertilizable;
            Direction currentDirection = Direction.from2DDataValue((int)(startDirection + i));
            BlockPos offsetPos = blockPos.relative(currentDirection);
            BlockState offsetState = world.getBlockState(offsetPos);
            Block block = offsetState.getBlock();
            if (!(block instanceof BonemealableBlock) || !(fertilizable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)world, offsetPos, offsetState) || !fertilizable.isBonemealSuccess((Level)world, world.random, offsetPos, offsetState)) continue;
            fertilizable.performBonemeal(world, world.getRandom(), offsetPos, offsetState);
            world.levelEvent(1505, offsetPos, 0);
            return true;
        }
        return true;
    }
}

