/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.gravity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.entity.entity.FloatBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FloatBlock
extends FallingBlock {
    public static final MapCodec<FloatBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)FloatBlock.propertiesCodec(), (App)Codec.FLOAT.fieldOf("gravity_mod").forGetter(FloatBlock::getGravityMod)).apply((Applicative)i, FloatBlock::new));
    private final float gravityMod;

    public FloatBlock(BlockBehaviour.Properties settings, float gravityMod) {
        super(settings);
        this.gravityMod = gravityMod;
    }

    public MapCodec<? extends FloatBlock> codec() {
        return CODEC;
    }

    public float getGravityMod() {
        return this.gravityMod;
    }

    public void onPlace(BlockState state, Level world, BlockPos blockPos, BlockState oldState, boolean notify) {
        world.scheduleTick(blockPos, (Block)this, this.getDelayAfterPlace());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos blockPos, BlockPos facingPos) {
        world.scheduleTick(blockPos, (Block)this, this.getDelayAfterPlace());
        return super.updateShape(state, direction, facingState, world, blockPos, facingPos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.checkForLaunch((Level)world, pos);
    }

    private void checkForLaunch(Level world, BlockPos pos) {
        if (!world.isClientSide) {
            if (this.gravityMod == 0.0f) {
                FloatBlock.launch(world, pos);
                return;
            }
            BlockPos collisionBlockPos = this.gravityMod > 0.0f ? pos.above() : pos.below();
            if (world.isEmptyBlock(collisionBlockPos) || FloatBlock.isFree((BlockState)world.getBlockState(collisionBlockPos))) {
                FloatBlock.launch(world, pos);
            }
        }
    }

    private static void launch(Level world, BlockPos pos) {
        FloatBlockEntity blockEntity = new FloatBlockEntity(world, pos, world.getBlockState(pos));
        world.addFreshEntity((Entity)blockEntity);
    }
}

