/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.gemstone;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.gemstone.PastelGemstoneBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class PastelBuddingBlock
extends PastelGemstoneBlock {
    private static final Direction[] DIRECTIONS = Direction.values();
    private final Block smallBlock;
    private final Block mediumBlock;
    private final Block largeBlock;
    private final Block clusterBlock;

    public PastelBuddingBlock(BlockBehaviour.Properties settings, Block smallBlock, Block mediumBlock, Block largeBlock, Block clusterBlock, SoundEvent hitSoundEvent, SoundEvent chimeSoundEvent) {
        super(settings, hitSoundEvent, chimeSoundEvent);
        this.smallBlock = smallBlock;
        this.mediumBlock = mediumBlock;
        this.largeBlock = largeBlock;
        this.clusterBlock = clusterBlock;
    }

    public MapCodec<? extends PastelBuddingBlock> codec() {
        return null;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(5) == 0) {
            Direction direction = UPDATE_SHAPE_ORDER[random.nextInt(UPDATE_SHAPE_ORDER.length)];
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            Block block = null;
            if (BuddingAmethystBlock.canClusterGrowAtState((BlockState)blockState)) {
                block = this.smallBlock;
            } else if (blockState.is(this.smallBlock) && blockState.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = this.mediumBlock;
            } else if (blockState.is(this.mediumBlock) && blockState.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = this.largeBlock;
            } else if (blockState.is(this.largeBlock) && blockState.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = this.clusterBlock;
            }
            if (block != null) {
                world.setBlockAndUpdate(blockPos, (BlockState)((BlockState)block.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockState.getFluidState().getType() == Fluids.WATER)));
            }
        }
    }
}

