/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class LiquidCrystalFluid
extends PastelFluid {
    public Fluid getSource() {
        return (Fluid)PastelFluids.LIQUID_CRYSTAL.get();
    }

    public Fluid getFlowing() {
        return (Fluid)PastelFluids.FLOWING_LIQUID_CRYSTAL.get();
    }

    public Item getBucket() {
        return (Item)PastelItems.LIQUID_CRYSTAL_BUCKET.get();
    }

    public FluidType getFluidType() {
        return (FluidType)PastelFluids.LIQUID_CRYSTAL_TYPE.get();
    }

    protected BlockState createLegacyBlock(FluidState fluidState) {
        return (BlockState)((Block)PastelBlocks.LIQUID_CRYSTAL.get()).defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(LiquidCrystalFluid.getLegacyLevel((FluidState)fluidState)));
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid == PastelFluids.LIQUID_CRYSTAL.get() || fluid == PastelFluids.FLOWING_LIQUID_CRYSTAL.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos topPos = pos.above();
        BlockState topState = world.getBlockState(topPos);
        if (topState.isAir() && !topState.isSolidRender((BlockGetter)world, topPos) && random.nextInt(1000) == 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PastelSounds.LIQUID_CRYSTAL_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @Override
    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        if (state.is(BlockTags.FLOWERS)) {
            Block.dropResources((BlockState)((Block)PastelBlocks.RESONANT_LILY.get()).defaultBlockState(), (LevelAccessor)world, (BlockPos)pos, null);
        } else {
            super.beforeDestroyingBlock(world, pos, state);
        }
    }

    public ParticleOptions getDripParticle() {
        return PastelParticleTypes.DRIPPING_LIQUID_CRYSTAL;
    }

    @Override
    public ParticleOptions getSplashParticle() {
        return PastelParticleTypes.LIQUID_CRYSTAL_SPLASH;
    }

    @Override
    public void onEntityCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.onEntityCollision(state, level, pos, entity);
        if (!level.isClientSide && entity instanceof LivingEntity) {
            MobEffectInstance regenerationInstance;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (level.getGameTime() % 200L == 0L && (regenerationInstance = livingEntity.getEffect(MobEffects.REGENERATION)) == null) {
                MobEffectInstance newRegenerationInstance = new MobEffectInstance(MobEffects.REGENERATION, 80);
                livingEntity.addEffect(newRegenerationInstance);
            }
        }
    }

    @Override
    public RecipeType<? extends FluidConvertingRecipe> getDippingRecipeType() {
        return PastelRecipeTypes.LIQUID_CRYSTAL_CONVERTING;
    }

    public static class Still
    extends LiquidCrystalFluid {
        public int getAmount(FluidState fluidState) {
            return 8;
        }

        public boolean isSource(FluidState fluidState) {
            return true;
        }
    }

    public static class Flowing
    extends LiquidCrystalFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState fluidState) {
            return false;
        }
    }
}

