/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.energy;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.energy.CrystalApothecaryBlockEntity;
import earth.terrarium.pastel.events.listeners.BlockPosEventQueue;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CrystalApothecaryBlock
extends BaseEntityBlock {
    public static final MapCodec<CrystalApothecaryBlock> CODEC = CrystalApothecaryBlock.simpleCodec(CrystalApothecaryBlock::new);

    public CrystalApothecaryBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends CrystalApothecaryBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystalApothecaryBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.crystal_apothecary.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CrystalApothecaryBlockEntity) {
            CrystalApothecaryBlockEntity crystalApothecaryBlockEntity = (CrystalApothecaryBlockEntity)blockEntity;
            if (placer instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)placer;
                crystalApothecaryBlockEntity.setOwner((Player)serverPlayerEntity);
            }
            crystalApothecaryBlockEntity.harvestExistingClusters();
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CrystalApothecaryBlockEntity) {
            CrystalApothecaryBlockEntity crystalApothecaryBlockEntity = (CrystalApothecaryBlockEntity)blockEntity;
            player.openMenu((MenuProvider)crystalApothecaryBlockEntity);
        }
        return InteractionResult.CONSUME;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return CrystalApothecaryBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.CRYSTAL_APOTHECARY.get()), CrystalApothecaryBlockEntity::tick);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel world, T blockEntity) {
        BlockPosEventQueue blockPosEventQueue;
        if (blockEntity instanceof CrystalApothecaryBlockEntity) {
            CrystalApothecaryBlockEntity crystalApothecaryBlockEntity = (CrystalApothecaryBlockEntity)blockEntity;
            blockPosEventQueue = crystalApothecaryBlockEntity.getEventListener();
        } else {
            blockPosEventQueue = null;
        }
        return blockPosEventQueue;
    }
}

