/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.energy;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.energy.ColorPickerBlockEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ColorPickerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<ColorPickerBlock> CODEC = ColorPickerBlock.simpleCodec(ColorPickerBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);

    public ColorPickerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends ColorPickerBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.color_picker.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ColorPickerBlockEntity(pos, state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : Support.checkType(type, (BlockEntityType)PastelBlockEntities.COLOR_PICKER.get(), ColorPickerBlockEntity::tick);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.openScreen(world, pos, player);
        return InteractionResult.CONSUME;
    }

    protected void openScreen(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ColorPickerBlockEntity) {
            ColorPickerBlockEntity colorPickerBlockEntity = (ColorPickerBlockEntity)blockEntity;
            colorPickerBlockEntity.setOwner(player);
            player.openMenu((MenuProvider)colorPickerBlockEntity);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof ColorPickerBlockEntity) {
            ColorPickerBlockEntity blockEntity2 = (ColorPickerBlockEntity)blockEntity;
            int i = 0;
            float f = 0.0f;
            for (int j = 0; j < blockEntity2.inventory.getSlots(); ++j) {
                ItemStack itemStack = blockEntity2.inventory.getStackInSlot(j);
                if (itemStack.isEmpty()) continue;
                f += (float)itemStack.getCount() / (float)itemStack.getMaxStackSize();
                ++i;
            }
            return Mth.floor((float)(f / (float)blockEntity2.inventory.getSlots() * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }
}

