/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.ender;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.block.PlayerOwnedWithName;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public class EnderDropperBlockEntity
extends DispenserBlockEntity
implements PlayerOwnedWithName {
    private UUID ownerUUID;
    private String ownerName;

    public EnderDropperBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.ENDER_DROPPER.get(), blockPos, blockState);
    }

    protected Component getDefaultName() {
        if (this.hasOwner()) {
            return Component.translatable((String)"block.pastel.ender_dropper.owner", (Object[])new Object[]{this.ownerName});
        }
        return Component.translatable((String)"block.pastel.ender_dropper");
    }

    public int getRandomSlot(RandomSource random) {
        return this.getInventory().map(inventory -> {
            int selectedIndex = -1;
            int chance = 1;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (inventory.getItem(i).isEmpty() || random.nextInt(chance++) != 0) continue;
                selectedIndex = i;
            }
            return selectedIndex;
        }).orElse(-1);
    }

    public ItemStack insertItem(ItemStack stack) {
        this.getInventory().ifPresent(inventory -> {
            int i = this.getMaxStackSize(stack);
            for (int j = 0; j < inventory.getContainerSize(); ++j) {
                ItemStack itemStack = inventory.getItem(j);
                if (!itemStack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) continue;
                int k = Math.min(stack.getCount(), i - itemStack.getCount());
                if (k > 0) {
                    if (itemStack.isEmpty()) {
                        this.setItem(j, stack.split(k));
                    } else {
                        stack.shrink(k);
                        itemStack.grow(k);
                    }
                }
                if (stack.isEmpty()) break;
            }
        });
        return stack;
    }

    public ItemStack getItem(int slot) {
        return this.getInventory().map(i -> i.getItem(slot)).orElse(ItemStack.EMPTY);
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.getInventory().ifPresent(i -> i.setItem(slot, itemStack));
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.getInventory().map(i -> i.removeItemNoUpdate(slot)).orElse(ItemStack.EMPTY);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.getInventory().map(i -> i.removeItem(slot, amount)).orElse(ItemStack.EMPTY);
    }

    public boolean isEmpty() {
        return this.getInventory().map(SimpleContainer::isEmpty).orElse(true);
    }

    public boolean canTakeItem(Container hopperInventory, int slot, ItemStack stack) {
        return false;
    }

    private Optional<PlayerEnderChestContainer> getInventory() {
        Player player = this.getOwnerIfOnline();
        if (player != null) {
            return Optional.of(player.getEnderChestInventory());
        }
        return Optional.empty();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.ownerName = playerEntity.getName().getString();
        this.setChanged();
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.ownerName = PlayerOwned.readOwnerName(nbt);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        PlayerOwned.writeOwnerName(nbt, this.ownerName);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.getInventory().map(SimpleContainer::getItems).orElse(NonNullList.create());
    }

    protected void setItems(NonNullList<ItemStack> inventory) {
        this.getInventory().ifPresent(inv -> {
            for (int i = 0; i < inventory.size(); ++i) {
                inv.setItem(i, (ItemStack)inventory.get(i));
            }
        });
    }

    public int getContainerSize() {
        return this.getInventory().map(SimpleContainer::getContainerSize).orElse(0);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return null;
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return null;
    }
}

