/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.groundcover;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;

public class SlushVegetationBlock
extends SnowyDirtBlock {
    public static final MapCodec<SlushVegetationBlock> CODEC = SlushVegetationBlock.simpleCodec(SlushVegetationBlock::new);

    public SlushVegetationBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends SlushVegetationBlock> codec() {
        return CODEC;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.setBlockAndUpdate(pos, ((Block)PastelBlocks.SLUSH.get()).defaultBlockState());
        }
    }

    private static boolean canSurvive(BlockState state, BlockGetter world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(Blocks.SNOW) && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockState.getFluidState().getAmount() == 8) {
            return false;
        }
        int light = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)blockState, (BlockPos)blockPos, (Direction)Direction.UP, (int)blockState.getLightBlock(world, blockPos));
        return light < world.getMaxLightLevel();
    }
}

