/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import earth.terrarium.pastel.helpers.level.BlockReference;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public abstract class TriStateVineBlock
extends BushBlock
implements BonemealableBlock {
    public static final EnumProperty<LifeStage> LIFE_STAGE = EnumProperty.create((String)"life_stage", LifeStage.class);
    private final int minHeight;
    private final float growthTickChance;
    private final float spreadChance;
    private final float overgrowth;

    public TriStateVineBlock(BlockBehaviour.Properties settings, int minHeight, float growthChance, float spreadChance, float overgrowth) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(LIFE_STAGE, (Comparable)((Object)LifeStage.GROWING)));
        this.minHeight = minHeight;
        this.growthTickChance = growthChance;
        this.spreadChance = spreadChance;
        this.overgrowth = overgrowth;
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockReference reference = BlockReference.of(state, pos);
        boolean creative = player.getAbilities().instabuild;
        if (handStack.is(Tags.Items.TOOLS_SHEAR)) {
            if (reference.getProperty(LIFE_STAGE) != LifeStage.GROWING) {
                return ItemInteractionResult.FAIL;
            }
            if (!creative) {
                handStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            reference.setProperty(LIFE_STAGE, LifeStage.MATURE);
            reference.update((LevelAccessor)world);
            world.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, Mth.randomBetween((RandomSource)world.random, (float)0.6f, (float)1.0f));
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)reference.getState()));
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (handStack.is((Item)PastelItems.MOONSTRUCK_NECTAR.get())) {
            if (reference.getProperty(LIFE_STAGE) != LifeStage.MATURE) {
                return ItemInteractionResult.FAIL;
            }
            if (!creative) {
                handStack.shrink(1);
            }
            reference.setProperty(LIFE_STAGE, LifeStage.GROWING);
            reference.update((LevelAccessor)world);
            world.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, Mth.randomBetween((RandomSource)world.random, (float)0.6f, (float)1.0f));
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)reference.getState()));
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = this.defaultBlockState();
        BlockReference roof = BlockReference.of((LevelAccessor)world, pos.above());
        if (!this.canSurvive(world.getBlockState(pos), (LevelReader)world, pos) || !world.isEmptyBlock(pos)) {
            return null;
        }
        if (roof.isOf((Block)this)) {
            state = (BlockState)state.setValue(LIFE_STAGE, (Comparable)((Object)roof.getProperty(LIFE_STAGE)));
            roof.setProperty(LIFE_STAGE, LifeStage.STALK);
            roof.update((LevelAccessor)world);
        }
        return state;
    }

    abstract boolean hasGrowthActions();

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue(LIFE_STAGE) != LifeStage.MATURE;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextFloat() >= this.growthTickChance) {
            return;
        }
        BlockReference reference = BlockReference.of(state, pos);
        LifeStage stage = reference.getProperty(LIFE_STAGE);
        if (this.hasGrowthActions() && random.nextBoolean() || stage != LifeStage.GROWING) {
            this.performBonemeal(world, random, pos, state);
        } else {
            if (!this.isBonemealSuccess((Level)world, random, pos, state) || random.nextFloat() >= this.spreadChance) {
                return;
            }
            reference.setProperty(LIFE_STAGE, LifeStage.STALK);
            reference.update((LevelAccessor)world);
            BlockState sprigState = this.defaultBlockState();
            int height = this.getCurrentHeight((Level)world, reference.pos);
            if (height >= this.minHeight && random.nextFloat() >= this.overgrowth) {
                sprigState = (BlockState)sprigState.setValue(LIFE_STAGE, (Comparable)((Object)LifeStage.MATURE));
            }
            world.setBlockAndUpdate(reference.pos.below(), sprigState);
        }
    }

    protected int getCurrentHeight(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        int count = 0;
        while (state.is((Block)this)) {
            state = world.getBlockState(pos.above(++count));
        }
        return count;
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockReference roof = BlockReference.of(world, pos.above());
        if (roof.isOf((Block)this)) {
            roof.setProperty(LIFE_STAGE, this.getLowestLifeStage(world, pos.below(), (LifeStage)((Object)state.getValue(LIFE_STAGE))));
            roof.update(world);
        }
        this.scheduleBreakCheck(world, pos);
    }

    public LifeStage getLowestLifeStage(LevelAccessor world, BlockPos pos, LifeStage stage) {
        BlockState state = world.getBlockState(pos);
        LifeStage lastStage = stage;
        while (state.is((Block)this)) {
            lastStage = (LifeStage)((Object)state.getValue(LIFE_STAGE));
            pos = pos.below();
            state = world.getBlockState(pos);
        }
        return lastStage;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return world.isEmptyBlock(pos.below());
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            return;
        }
        this.scheduleBreakCheck((LevelAccessor)world, pos);
        world.destroyBlock(pos, true);
    }

    private void scheduleBreakCheck(LevelAccessor world, BlockPos pos) {
        BlockPos underside = pos.below();
        if (world.getBlockState(underside).is((Block)this)) {
            world.scheduleTick(underside, (Block)this, 1);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos roof = pos.above();
        BlockState roofState = world.getBlockState(roof);
        if (roofState.is((Block)this)) {
            return true;
        }
        return this.mayPlaceOn(roofState, (BlockGetter)world, roof);
    }

    public boolean mayPlaceOn(BlockState roof, BlockGetter world, BlockPos pos) {
        return roof.isFaceSturdy(world, pos, Direction.DOWN);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIFE_STAGE});
    }

    public float getMaxHorizontalOffset() {
        return 0.1f;
    }

    public float getMaxVerticalOffset() {
        return -0.15f;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(world, pos);
        return super.getShape(state, world, pos, context).move(vec3d.x, vec3d.y, vec3d.z);
    }

    public static enum LifeStage implements StringRepresentable
    {
        STALK("stalk"),
        GROWING("growing"),
        MATURE("mature");

        private final String name;

        private LifeStage(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

