/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.blocks.deeper_down.flora.Dragonjag;
import earth.terrarium.pastel.blocks.deeper_down.flora.TallDragonjagBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallDragonjagBlock
extends BushBlock
implements Dragonjag,
BonemealableBlock {
    public static final MapCodec<SmallDragonjagBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SmallDragonjagBlock.propertiesCodec(), (App)Dragonjag.Variant.CODEC.fieldOf("variant").forGetter(SmallDragonjagBlock::getVariant)).apply((Applicative)i, SmallDragonjagBlock::new));
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final Map<Dragonjag.Variant, Block> VARIANTS = new HashMap<Dragonjag.Variant, Block>();
    protected final Dragonjag.Variant variant;

    public SmallDragonjagBlock(BlockBehaviour.Properties settings, Dragonjag.Variant variant) {
        super(settings);
        this.variant = variant;
        VARIANTS.put(variant, (Block)this);
    }

    public MapCodec<? extends SmallDragonjagBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return Dragonjag.canPlantOnTop(floor, world, pos);
    }

    @Override
    public Dragonjag.Variant getVariant() {
        return this.variant;
    }

    public static Block getBlockForVariant(Dragonjag.Variant variant) {
        return VARIANTS.get((Object)variant);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        TallDragonjagBlock tallVariant = TallDragonjagBlock.getBlockForVariant(this.variant);
        if (tallVariant.defaultBlockState().canSurvive((LevelReader)world, pos) && world.isEmptyBlock(pos.above())) {
            TallDragonjagBlock.placeAt((LevelAccessor)world, (BlockState)tallVariant.defaultBlockState(), (BlockPos)pos, (int)2);
        }
    }
}

