/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.SpreadableFloraBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MossBallBlock
extends SpreadableFloraBlock {
    public static final MapCodec<MossBallBlock> CODEC = MossBallBlock.simpleCodec(MossBallBlock::new);
    private static final VoxelShape SHAPE = MossBallBlock.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);

    public MossBallBlock(BlockBehaviour.Properties settings) {
        super(3, settings);
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance / 2.0f);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(world, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    public float getMaxHorizontalOffset() {
        return 0.2f;
    }

    public float getMaxVerticalOffset() {
        return 0.125f;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return true;
    }
}

