/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public interface Dragonjag {
    public Variant getVariant();

    public static boolean canPlantOnTop(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.isSolidRender(world, pos);
    }

    public static enum Variant implements StringRepresentable
    {
        YELLOW(MapColor.SAND),
        RED(MapColor.NETHER),
        PINK(MapColor.WARPED_HYPHAE),
        PURPLE(MapColor.COLOR_PURPLE),
        BLACK(MapColor.TERRACOTTA_BLACK);

        public static final Codec<Variant> CODEC;
        private final MapColor mapColor;

        private Variant(MapColor mapColor) {
            this.mapColor = mapColor;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

