/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AloeBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<AloeBlock> CODEC = AloeBlock.simpleCodec(AloeBlock::new);
    protected static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);
    protected static final double GROW_CHANCE = 0.4;
    protected static final int MAX_LIGHT_LEVEL = 10;

    public AloeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends AloeBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getRawBrightness(pos, 0) <= 10 && super.canSurvive(state, world, pos);
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(PastelBlockTags.ALOE_PLANTABLE);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return world.getRawBrightness(pos, 0) <= 10 && (double)random.nextFloat() > 0.4;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age < 4) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                world.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (world.getBlockState(pos.below()).is(PastelBlockTags.ALOE_CONVERTED)) {
                    world.setBlockAndUpdate(pos.below(), Blocks.SAND.defaultBlockState());
                }
            }
        } else {
            Block.updateOrDestroy((BlockState)state, (BlockState)Blocks.AIR.defaultBlockState(), (LevelAccessor)world, (BlockPos)pos, (int)10, (int)512);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.performBonemeal(world, random, pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age > 1) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1)));
            player.getInventory().placeItemBackInInventory(this.asItem().getDefaultInstance());
            world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 0.9f + world.random.nextFloat() * 0.2f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

