/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.block.StrippableDrop;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class StrippingLootPillarBlock
extends RotatedPillarBlock
implements StrippableDrop {
    private final Block sourceBlock;
    private final ResourceKey<LootTable> strippingLootTableKey;

    public StrippingLootPillarBlock(BlockBehaviour.Properties settings, Block sourceBlock, ResourceKey<LootTable> strippingLootTableKey) {
        super(settings);
        this.sourceBlock = sourceBlock;
        this.strippingLootTableKey = strippingLootTableKey;
    }

    public MapCodec<? extends StrippingLootPillarBlock> codec() {
        return null;
    }

    @Override
    public Block getStrippedBlock() {
        return this.sourceBlock;
    }

    @Override
    public ResourceKey<LootTable> getStrippingLootTableKey() {
        return this.strippingLootTableKey;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        this.checkAndDropStrippedLoot(state, world, pos, newState, moved);
        super.onRemove(state, world, pos, newState, moved);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        ItemStack itemStack = context.getItemInHand();
        if (!itemStack.canPerformAction(itemAbility)) {
            return null;
        }
        if (ItemAbilities.AXE_STRIP == itemAbility) {
            return (BlockState)this.sourceBlock.defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)));
        }
        return null;
    }
}

