/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ShimmerstoneLightBlock
extends DirectionalBlock {
    public static final MapCodec<ShimmerstoneLightBlock> CODEC = ShimmerstoneLightBlock.simpleCodec(ShimmerstoneLightBlock::new);
    protected static final VoxelShape SHAPE_UP = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);

    public ShimmerstoneLightBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends ShimmerstoneLightBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
        }
        return SHAPE_WEST;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Player player;
        boolean inverted = ctx.getClickedFace().getStepY() != 0 ? ctx.getHorizontalDirection().getStepX() != 0 : (player = ctx.getPlayer()) != null && player.isShiftKeyDown();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getClickedFace())).setValue((Property)BlockStateProperties.INVERTED, (Comparable)Boolean.valueOf(inverted));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.getOpposite() == state.getValue((Property)BlockStateProperties.FACING) && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.INVERTED});
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if ((double)random.nextFloat() < 0.3) {
            double e;
            double d;
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            double d2 = direction.getStepX() == 0 ? 0.3 + (double)(random.nextFloat() * 0.4f) : (d = direction.getStepX() == 1 ? 0.15 : 0.85);
            double d3 = direction.getStepY() == 0 ? 0.3 + (double)(random.nextFloat() * 0.4f) : (e = direction.getStepY() == 1 ? 0.15 : 0.85);
            double f = direction.getStepZ() == 0 ? 0.3 + (double)(random.nextFloat() * 0.4f) : (direction.getStepZ() == 1 ? 0.15 : 0.85);
            world.addParticle((ParticleOptions)PastelParticleTypes.SHIMMERSTONE_SPARKLE_SMALL, (double)pos.getX() + d, (double)pos.getY() + e, (double)pos.getZ() + f, 0.0, 0.02, 0.0);
        }
    }
}

