/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.blocks.decoration.ProjectorBlockEntity;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ProjectorBlockEntityRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    protected static EntityRenderDispatcher dispatcher;

    public ProjectorBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
    }

    public void render(ProjectorBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        float time = (float)(entity.getLevel().getGameTime() % 24000L) + tickDelta;
        double bob = Math.sin(time / 19.0f) * 0.075 * (double)entity.bobMultiplier;
        matrices.pushPose();
        matrices.translate(0.5, (double)entity.heightOffset + bob, 0.5);
        Vec3 center = Vec3.atLowerCornerOf((Vec3i)entity.getBlockPos()).add(0.5, 0.0, 0.5);
        double xOffset = center.x() - ProjectorBlockEntityRenderer.dispatcher.camera.getPosition().x;
        double zOffset = center.z() - ProjectorBlockEntityRenderer.dispatcher.camera.getPosition().z;
        matrices.mulPose(Axis.YP.rotation((float)Mth.atan2((double)xOffset, (double)zOffset)));
        VertexConsumer buffer = vertexConsumers.getBuffer(RenderType.entityTranslucent((ResourceLocation)entity.texture));
        RenderHelper.renderFlatTrans(matrices, buffer, false, entity.scaling, 0.75f, 0.0f, overlay);
        matrices.popPose();
    }
}

