/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AlternatePlayerOnlyGlassBlock
extends TransparentBlock {
    private final Block alternateBlock;
    private final boolean tinted;

    public AlternatePlayerOnlyGlassBlock(BlockBehaviour.Properties settings, Block block, boolean tinted) {
        super(settings);
        this.alternateBlock = block;
        this.tinted = tinted;
    }

    public MapCodec<? extends AlternatePlayerOnlyGlassBlock> codec() {
        return null;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityShapeContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityShapeContext = (EntityCollisionContext)context).getEntity()) instanceof Player) {
            return Shapes.empty();
        }
        return state.getShape(world, pos);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return !this.tinted;
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        if (this.tinted) {
            return world.getMaxLightLevel();
        }
        return super.getLightBlock(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.is((Block)this) || stateFrom.getBlock() == this.alternateBlock) {
            return true;
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    public Block getAlternateBlock() {
        return this.alternateBlock;
    }
}

