/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decay;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.decay.DecayBlock;
import earth.terrarium.pastel.blocks.decay.FailingBlock;
import earth.terrarium.pastel.blocks.decay.ForfeitureBlock;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelLevels;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecayAwayBlock
extends Block {
    public static final MapCodec<DecayAwayBlock> CODEC = DecayAwayBlock.simpleCodec(DecayAwayBlock::new);
    private static final EnumProperty<TargetConversion> TARGET_CONVERSION = EnumProperty.create((String)"target_conversion", TargetConversion.class);

    public DecayAwayBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TARGET_CONVERSION, (Comparable)((Object)TargetConversion.DEFAULT)));
    }

    protected MapCodec<? extends DecayAwayBlock> codec() {
        return CODEC;
    }

    public void setPlacedBy(@NotNull Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide) {
            world.scheduleTick(pos, state.getBlock(), 4);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{TARGET_CONVERSION});
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        for (BlockPos targetBlockPos : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
            BlockState currentBlockState = world.getBlockState(targetBlockPos);
            if (currentBlockState.is(PastelBlockTags.DECAY_AWAY_CURABLES)) {
                world.setBlockAndUpdate(targetBlockPos, this.getTargetStateForCurable(currentBlockState));
                world.scheduleTick(targetBlockPos, state.getBlock(), 8);
                continue;
            }
            if (!currentBlockState.is(PastelBlockTags.DECAY_AWAY_REMOVABLES)) continue;
            world.setBlockAndUpdate(targetBlockPos, (BlockState)this.defaultBlockState().setValue(TARGET_CONVERSION, (Comparable)((Object)TargetConversion.AIR)));
            world.scheduleTick(targetBlockPos, state.getBlock(), 8);
        }
        BlockState currentState = world.getBlockState(pos);
        TargetConversion targetConversion = (TargetConversion)((Object)currentState.getValue(TARGET_CONVERSION));
        world.setBlock(pos, targetConversion.getTargetState((Level)world), 3);
    }

    public BlockState getTargetStateForCurable(BlockState blockState) {
        if (blockState.getBlock() instanceof DecayBlock) {
            if (blockState.is((Block)PastelBlocks.RUIN.get()) || blockState.is((Block)PastelBlocks.FORFEITURE.get())) {
                if (blockState.getValue((Property)ForfeitureBlock.CONVERSION) == DecayBlock.Conversion.DEFAULT) {
                    return (BlockState)this.defaultBlockState().setValue(TARGET_CONVERSION, (Comparable)((Object)TargetConversion.BEDROCK));
                }
            } else if (blockState.is((Block)PastelBlocks.FAILING.get())) {
                if (blockState.getValue((Property)FailingBlock.CONVERSION) == DecayBlock.Conversion.DEFAULT) {
                    return (BlockState)this.defaultBlockState().setValue(TARGET_CONVERSION, (Comparable)((Object)TargetConversion.OBSIDIAN));
                }
                if (blockState.getValue((Property)FailingBlock.CONVERSION) == DecayBlock.Conversion.SPECIAL) {
                    return (BlockState)this.defaultBlockState().setValue(TARGET_CONVERSION, (Comparable)((Object)TargetConversion.CRYING_OBSIDIAN));
                }
            }
        }
        return this.defaultBlockState();
    }

    public static enum TargetConversion implements StringRepresentable
    {
        DEFAULT("default", Blocks.DIRT.defaultBlockState()),
        BEDROCK("bedrock", Blocks.BEDROCK.defaultBlockState()),
        OBSIDIAN("obsidian", Blocks.OBSIDIAN.defaultBlockState()),
        CRYING_OBSIDIAN("crying_obsidian", Blocks.CRYING_OBSIDIAN.defaultBlockState()),
        AIR("air", Blocks.AIR.defaultBlockState());

        private final String name;
        private final BlockState targetState;

        private TargetConversion(String name, BlockState targetState) {
            this.name = name;
            this.targetState = targetState;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public BlockState getTargetState(Level world) {
            if (this == DEFAULT) {
                ResourceLocation identifier = world.dimensionType().effectsLocation();
                if (BuiltinDimensionTypes.NETHER_EFFECTS.equals((Object)identifier)) {
                    return Blocks.NETHERRACK.defaultBlockState();
                }
                if (BuiltinDimensionTypes.END_EFFECTS.equals((Object)identifier)) {
                    return Blocks.END_STONE.defaultBlockState();
                }
                if (PastelLevels.DIMENSION_ID.equals((Object)identifier)) {
                    return ((Block)PastelBlocks.BLACKSLAG.get()).defaultBlockState();
                }
                return Blocks.DIRT.defaultBlockState();
            }
            return this.targetState;
        }
    }
}

