/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decay;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class BlackMateriaBlock
extends FallingBlock {
    public static final MapCodec<BlackMateriaBlock> CODEC = BlackMateriaBlock.simpleCodec(BlackMateriaBlock::new);
    public static final int PROPAGATION_TRIES = 3;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public BlackMateriaBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(3)));
    }

    protected MapCodec<? extends BlackMateriaBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        return state;
    }

    public static boolean spreadBlackMateria(Level world, BlockPos pos, RandomSource random, BlockState targetState) {
        boolean replacedAny = false;
        for (int i = 0; i < 3; ++i) {
            Direction randomDirection = Direction.getRandom((RandomSource)random);
            BlockPos neighborPos = pos.relative(randomDirection);
            BlockState neighborBlockState = world.getBlockState(neighborPos);
            if (neighborBlockState.getBlock() instanceof BlackMateriaBlock || !neighborBlockState.is(PastelBlockTags.BLACK_MATERIA_CONVERSIONS)) continue;
            world.setBlockAndUpdate(neighborPos, targetState);
            world.playSound(null, neighborPos, SoundEvents.GRAVEL_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
            replacedAny = true;
        }
        return replacedAny;
    }

    protected int getDelayAfterPlace() {
        return 20;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) != 3;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 3) {
            BlockState targetState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            BlackMateriaBlock.spreadBlackMateria((Level)world, pos, random, targetState);
            world.setBlockAndUpdate(pos, targetState);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public void onBrokenAfterFall(Level world, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        BlockState state = world.getBlockState(pos);
        if (!state.isSolid() && state.getPistonPushReaction() == PushReaction.DESTROY) {
            world.destroyBlock(pos, true, (Entity)fallingBlockEntity, 4);
        }
        super.onBrokenAfterFall(world, pos, fallingBlockEntity);
    }
}

