/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.crystallarieum;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.blocks.crystallarieum.CrystallarieumBlockEntity;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import earth.terrarium.pastel.render.FluidRendering;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class CrystallarieumBlockEntityRenderer<T extends CrystallarieumBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Material SPRITE = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/crystallarieum"));
    private final ModelPart active;
    private final ModelPart inactive;
    private final ModelPart halo;
    private final ModelPart echo;
    private final ModelPart upperecho;

    public CrystallarieumBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = CrystallarieumBlockEntityRenderer.getTexturedModelData().bakeRoot();
        this.active = root.getChild("active");
        this.inactive = root.getChild("inactive");
        this.halo = root.getChild("halo");
        this.echo = this.halo.getChild("echo");
        this.upperecho = this.echo.getChild("upperecho");
    }

    public void render(CrystallarieumBlockEntity crystal, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemStack catalystStack;
        if (crystal.animator == null) {
            return;
        }
        crystal.animator.animate(tickDelta, 0L);
        VertexConsumer vertices = SPRITE.buffer(vertexConsumers, RenderType::entityTranslucent);
        this.renderHalo(crystal, tickDelta, matrices, vertexConsumers, light, overlay, vertices);
        FluidStack fluid = crystal.tank.getFluid();
        if (!fluid.isEmpty()) {
            matrices.pushPose();
            IClientFluidTypeExtensions renderData = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            TextureAtlasSprite sprite = FluidSpriteCache.getSprite((ResourceLocation)renderData.getStillTexture(fluid));
            BlockPos pos = crystal.getBlockPos().above();
            int luminance = fluid.getFluidType().getLightLevel(fluid);
            int skylight = crystal.getLevel().getBrightness(LightLayer.BLOCK, pos);
            int glow = LightTexture.pack((int)Math.max(luminance, skylight), (int)crystal.getLevel().getBrightness(LightLayer.SKY, pos));
            boolean full = crystal.tank.getFluidAmount() == 1000;
            float y = full ? 0.975f : 0.94f;
            int rim = full ? 1 : 2;
            int[] colors = FluidRendering.unpackColor(renderData.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)crystal.getLevel(), crystal.getBlockPos()));
            FluidRendering.renderFluid(vertexConsumers.getBuffer(RenderType.translucent()), matrices.last().pose(), sprite, glow, overlay, rim, 16 - rim, y, rim, 16 - rim, colors);
            matrices.popPose();
        }
        if ((catalystStack = crystal.getItem(0)).isEmpty()) {
            return;
        }
        CrystallarieumBlockEntityRenderer.renderCatalysts(crystal, matrices, vertexConsumers, light, overlay, catalystStack);
    }

    private void renderHalo(CrystallarieumBlockEntity crystal, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, VertexConsumer vertices) {
        matrices.pushPose();
        matrices.translate(0.5, 1.5, 0.5);
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        InkColor ink = InkColors.WHITE;
        long time = crystal.getLevel() != null ? crystal.getLevel().getGameTime() % 1000000L : 0L;
        double bounce = (Math.sin(((float)time + tickDelta) / 23.0f) + 1.0) * (double)crystal._bounce.get().floatValue() / 2.0;
        if (crystal.currentRecipe != null) {
            ink = ((CrystallarieumRecipe)crystal.currentRecipe.value()).getInkColor();
            this.active.render(matrices, vertices, 0xF000F0, overlay, ink.getColorInt());
        } else {
            this.inactive.render(matrices, vertices, light, overlay);
        }
        crystal.rotation += crystal._speed.get().floatValue();
        matrices.mulPose(Axis.YP.rotationDegrees(crystal.rotation));
        int argb = FastColor.ARGB32.color((int)Math.round(crystal._alpha.get().floatValue() * 255.0f), (int)ink.getColorInt());
        this.halo.y = (float)(-9.0 - bounce);
        matrices.mulPose(Axis.YP.rotationDegrees(-crystal.rotation * 2.0f));
        this.echo.y = (float)(0.5 - bounce / 3.0);
        matrices.mulPose(Axis.YP.rotationDegrees(crystal.rotation * 1.5f));
        this.upperecho.y = (float)(-0.5 - bounce / 3.0);
        this.halo.render(matrices, vertices, 0xF000F0, overlay, argb);
        ItemStack inkStorageStack = crystal.getItem(1);
        if (!inkStorageStack.isEmpty()) {
            matrices.scale(0.65f, 0.65f, 0.65f);
            matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrices.translate(0.0, 0.975 + bounce / 3.0, 0.0);
            Minecraft.getInstance().getItemRenderer().renderStatic(inkStorageStack, ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, crystal.getLevel(), 0);
        }
        matrices.popPose();
    }

    private static void renderCatalysts(CrystallarieumBlockEntity crystal, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, ItemStack catalystStack) {
        matrices.pushPose();
        int stack = (int)Math.ceil((double)catalystStack.getCount() / 17.0);
        matrices.translate(0.5, 0.4, 0.5);
        matrices.mulPose(Axis.XP.rotationDegrees(270.0f));
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(70.0f));
        if (stack == 1) {
            Minecraft.getInstance().getItemRenderer().renderStatic(catalystStack, ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, crystal.getLevel(), 0);
            matrices.popPose();
            return;
        }
        for (int i = 0; i < stack; ++i) {
            Minecraft.getInstance().getItemRenderer().renderStatic(catalystStack, ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, crystal.getLevel(), 0);
            matrices.translate(0.0, 0.0, -0.0225);
            matrices.mulPose(Axis.ZP.rotationDegrees(53.0f));
        }
        matrices.popPose();
    }

    public int getViewDistance() {
        return 48;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition active = modelPartData.addOrReplaceChild("active", CubeListBuilder.create().texOffs(40, 34).addBox(-5.0f, -3.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition inactive = modelPartData.addOrReplaceChild("inactive", CubeListBuilder.create().texOffs(80, 34).addBox(-5.0f, -3.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition halo = modelPartData.addOrReplaceChild("halo", CubeListBuilder.create().texOffs(77, 48).addBox(-8.5f, 1.0f, -8.5f, 17.0f, 0.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition diamond_r1 = halo.addOrReplaceChild("diamond_r1", CubeListBuilder.create().texOffs(80, 65).addBox(-7.5f, 0.0f, -7.5f, 15.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition echo = halo.addOrReplaceChild("echo", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition echoring_r1 = echo.addOrReplaceChild("echoring_r1", CubeListBuilder.create().texOffs(80, 80).addBox(-7.5f, 0.0f, -7.5f, 15.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition upperecho = echo.addOrReplaceChild("upperecho", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition echoring_r2 = upperecho.addOrReplaceChild("echoring_r2", CubeListBuilder.create().texOffs(80, 95).addBox(-7.5f, 0.0f, -7.5f, 15.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)128, (int)128);
    }
}

