/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.conditional;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StuckStormStoneBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<StuckStormStoneBlock> CODEC = StuckStormStoneBlock.simpleCodec(StuckStormStoneBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)11.0, (double)2.0, (double)11.0);

    public StuckStormStoneBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends StuckStormStoneBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isRedstoneConductor((BlockGetter)world, pos);
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void wasExploded(Level world, BlockPos pos, Explosion explosion) {
        LightningBolt lightningEntity;
        super.wasExploded(world, pos, explosion);
        if (world.canSeeSky(pos) && (lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world)) != null) {
            lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
            world.addFreshEntity((Entity)lightningEntity);
        }
        int power = 2;
        Biome biomeAtPos = (Biome)world.getBiome(pos).value();
        if (!biomeAtPos.hasPrecipitation() && !biomeAtPos.coldEnoughToSnow(pos)) {
            power = world.isThundering() ? 4 : (world.isRaining() ? 3 : 2);
        }
        world.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)power, Level.ExplosionInteraction.BLOCK);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() < 0.1) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)PastelItems.STORM_STONE.get());
    }
}

