/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.conditional;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.FluidLogging;
import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelFluidTags;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MermaidsBrushBlock
extends BushBlock
implements BonemealableBlock,
FluidLogging.PastelFluidFillable {
    public static final MapCodec<MermaidsBrushBlock> CODEC = MermaidsBrushBlock.simpleCodec(MermaidsBrushBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final EnumProperty<FluidLogging.State> LOGGED = FluidLogging.ANY_EXCLUDING_NONE;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;

    public MermaidsBrushBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.WATER)));
    }

    public MapCodec<? extends MermaidsBrushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)PastelItems.MERMAIDS_GEM.get());
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        ((FluidLogging.State)((Object)state.getValue(LOGGED))).onEntityCollision(state, world, pos, entity);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        if (fluidState.getType() == PastelFluids.LIQUID_CRYSTAL.get()) {
            return (BlockState)super.getStateForPlacement(ctx).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.LIQUID_CRYSTAL));
        }
        if (fluidState.is(FluidTags.WATER)) {
            return (BlockState)super.getStateForPlacement(ctx).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.WATER));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (state.getValue(LOGGED) == FluidLogging.State.LIQUID_CRYSTAL) {
            world.scheduleTick(pos, (Fluid)PastelFluids.LIQUID_CRYSTAL.get(), ((PastelFluid)((Object)PastelFluids.LIQUID_CRYSTAL.get())).getTickDelay((LevelReader)world));
        } else {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return ((FluidLogging.State)((Object)state.getValue(LOGGED))).getFluidState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, LOGGED});
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 7) {
            ItemEntity pearlEntity = new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)PastelItems.MERMAIDS_GEM.get(), 1));
            world.addFreshEntity((Entity)pearlEntity);
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
        } else {
            float chance;
            float f = chance = state.getValue(LOGGED) == FluidLogging.State.LIQUID_CRYSTAL ? 0.5f : 0.2f;
            if (random.nextFloat() < chance) {
                world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 3);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        FluidState fluidState = world.getFluidState(pos);
        return (fluidState.is(FluidTags.WATER) || fluidState.is(PastelFluidTags.LIQUID_CRYSTAL)) && world.getBlockState(pos.below()).is(PastelBlockTags.MERMAIDS_BRUSH_PLANTABLE);
    }

    @Override
    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    @Override
    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        float chance;
        int attempts;
        int age = (Integer)state.getValue((Property)AGE);
        int nextAge = age + random.nextIntBetweenInclusive(1, (int)Math.ceil((float)(attempts = 7) * (chance = state.getValue(LOGGED) == FluidLogging.State.LIQUID_CRYSTAL ? 1.0f : 0.5f)));
        if (nextAge >= 8) {
            ItemEntity pearlEntity = new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)PastelItems.MERMAIDS_GEM.get(), 1));
            world.addFreshEntity((Entity)pearlEntity);
        }
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(nextAge % 8)), 3);
    }
}

