/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.chests.HeartboundChestBlockEntity;
import earth.terrarium.pastel.blocks.chests.PastelChestBlock;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HeartboundChestBlock
extends PastelChestBlock {
    public static final MapCodec<HeartboundChestBlock> CODEC = HeartboundChestBlock.simpleCodec(HeartboundChestBlock::new);

    public HeartboundChestBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HeartboundChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? HeartboundChestBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.HEARTBOUND_CHEST.get()), PastelChestBlockEntity::clientTick) : null;
    }

    @Override
    public void openScreen(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity) {
            HeartboundChestBlockEntity heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity;
            if (!heartboundChestBlockEntity.hasOwner()) {
                heartboundChestBlockEntity.setOwner(player);
            }
            if (!HeartboundChestBlock.isChestBlocked((LevelAccessor)world, pos)) {
                player.openMenu((MenuProvider)heartboundChestBlockEntity);
            }
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity) {
            HeartboundChestBlockEntity heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity;
            if (placer instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)placer;
                heartboundChestBlockEntity.setOwner((Player)serverPlayerEntity);
            }
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity) {
            if (((HeartboundChestBlockEntity)blockEntity).wasRecentlyTriedToOpenByNonOwner()) {
                return 15;
            }
            int lookingPlayers = HeartboundChestBlockEntity.getPlayersLookingInChestCount(world, pos);
            if (lookingPlayers > 0) {
                return 7;
            }
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return direction == Direction.UP ? state.getSignal(world, pos, direction) : 0;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        HeartboundChestBlockEntity heartboundChestBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof HeartboundChestBlockEntity && (heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity).canBreak(player.getUUID())) {
            float hardness = 20.0f;
            int i = player.hasCorrectToolForDrops(state) ? 30 : 100;
            return player.getDestroySpeed(state) / hardness / (float)i;
        }
        return -1.0f;
    }

    public float defaultDestroyTime() {
        return -1.0f;
    }
}

