/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.api.item.ItemStorage;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.inventories.AutoCraftingMode;
import earth.terrarium.pastel.inventories.CompactingChestScreenHandler;
import earth.terrarium.pastel.networking.s2c_payloads.CompactingChestStatusUpdatePayload;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.render.animation.FlowAnimator;
import earth.terrarium.pastel.render.animation.FlowData;
import earth.terrarium.pastel.render.animation.FlowHandlers;
import earth.terrarium.pastel.render.animation.FlowStates;
import earth.terrarium.pastel.render.animation.Interpolation;
import earth.terrarium.pastel.render.animation.KeyFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CompactingChestBlockEntity
extends PastelChestBlockEntity {
    private static final FlowAnimator.Factory<CompactingChestBlockEntity> FACTORY;
    @NotNull
    private AutoCraftingMode mode = AutoCraftingMode.X3;
    @NotNull
    private Optional<RecipeHolder<CraftingRecipe>> cachedRecipe = Optional.empty();
    private boolean isOpen;
    public long craftingTimeStamp;
    protected FlowAnimator animator;
    protected FlowData<Float> _piston = FlowData.NULL();
    protected FlowData<Float> _driver = FlowData.NULL();
    protected FlowData<Float> _cap = FlowData.NULL();
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            if (index == 0) {
                return CompactingChestBlockEntity.this.mode.ordinal();
            }
            return 0;
        }

        public void set(int index, int value) {
            if (index == 0) {
                CompactingChestBlockEntity.this.mode = AutoCraftingMode.values()[value];
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public CompactingChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.COMPACTING_CHEST.get(), blockPos, blockState);
        this.inventory.addListener(i -> this.setChanged());
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CompactingChestBlockEntity chest) {
        if (world.isClientSide()) {
            chest.updateAnimator();
        } else {
            chest.process();
        }
    }

    private void updateAnimator() {
        if (this.animator == null) {
            this.animator = FACTORY.create(FlowStates.CLOSED, this);
        }
        this.animator.tick();
        if (this.isOpen) {
            this.animator.swapState(FlowStates.OPEN);
        } else if (this.level.getGameTime() - this.craftingTimeStamp < 20L) {
            this.animator.swapState(FlowStates.ACTIVE);
        } else {
            this.animator.swapState(FlowStates.CLOSED);
        }
    }

    private void process() {
        List<ItemStorage> available = InventoryHelper.getAvailableItems((IItemHandler)this.inventory);
        if (this.cachedRecipe.isEmpty()) {
            this.findRecipe(available);
            return;
        }
        RecipeHolder<CraftingRecipe> recipe = this.cachedRecipe.get();
        ItemReference ref = AutoCraftingMode.getCache(this.mode).getOrDefault(recipe.id(), ItemReference.empty());
        if (ref.isEmpty()) {
            return;
        }
        if (!this.hasEnough(ref, available)) {
            this.cachedRecipe = Optional.empty();
            return;
        }
        ItemStack result = ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy();
        if (!ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)result, (boolean)true).isEmpty()) {
            return;
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)result, (boolean)false);
        InventoryHelper.extractFromInventory((IItemHandler)this.inventory, ref, this.mode.getSize());
        this.craftingTimeStamp = this.level.getGameTime();
        this.produceRunningEffects();
        if (this.level.getGameTime() % 5L == 0L) {
            CompactingChestStatusUpdatePayload.sendCompactingChestStatusUpdate(this);
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.worldPosition);
        }
    }

    private boolean hasEnough(ItemReference ref, List<ItemStorage> available) {
        if (available.isEmpty()) {
            return false;
        }
        for (ItemStorage itemStorage : available) {
            if (!itemStorage.getReference().equals(ref) || itemStorage.getCount() < (long)this.mode.getSize()) continue;
            return true;
        }
        return false;
    }

    private void findRecipe(List<ItemStorage> available) {
        CraftingInput input = null;
        ItemReference target = null;
        for (ItemStorage storage : available) {
            if (storage.getCount() < (long)this.mode.getSize()) continue;
            input = this.mode.createRecipeInput(storage.stack(1)).input();
            target = storage.getReference();
            this.cachedRecipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, this.level);
            if (!this.cachedRecipe.isPresent()) continue;
            break;
        }
        if (input == null) {
            return;
        }
        ItemReference finalTarget = target;
        this.cachedRecipe.ifPresent(r -> {
            Map<ResourceLocation, ItemReference> recipes = AutoCraftingMode.getCache(this.mode);
            recipes.putIfAbsent(r.id(), finalTarget);
            this.craftingTimeStamp = this.level.getGameTime();
            CompactingChestStatusUpdatePayload.sendCompactingChestStatusUpdate(this);
        });
    }

    public void produceRunningEffects() {
        RandomSource random = this.level.getRandom();
        if (random.nextFloat() < 0.04f) {
            this.level.playSound(null, this.worldPosition, SoundEvents.REDSTONE_TORCH_BURNOUT, SoundSource.BLOCKS, 0.05f + random.nextFloat() * 0.1f, 0.334f + random.nextFloat() / 2.0f);
            for (int i = 0; i < 4 + random.nextInt(5); ++i) {
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)((float)this.worldPosition.getX() + random.nextFloat()), (double)((float)(this.worldPosition.getY() + 1) + random.nextFloat() * 0.667f), (double)((float)this.worldPosition.getZ() + random.nextFloat()), 0, 0.0, (double)(random.nextFloat() / 20.0f + 0.02f), 0.0, 1.0);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.pastel.compacting_chest");
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        if (tag.contains("AutoCraftingMode", 99)) {
            int autoCraftingModeInt = tag.getInt("AutoCraftingMode");
            this.mode = AutoCraftingMode.values()[autoCraftingModeInt];
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        tag.putInt("AutoCraftingMode", this.mode.ordinal());
    }

    @Override
    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.isOpen = data > 0;
        }
        return super.triggerEvent(type, data);
    }

    @Override
    public SoundEvent getOpenSound() {
        return PastelSounds.COMPACTING_CHEST_OPEN;
    }

    @Override
    public SoundEvent getCloseSound() {
        return PastelSounds.COMPACTING_CHEST_CLOSE;
    }

    public void applySettings(AutoCraftingMode mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.cachedRecipe = Optional.empty();
        this.setChanged();
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new CompactingChestScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        BlockPos.STREAM_CODEC.encode((Object)buffer, (Object)this.worldPosition);
    }

    public int getContainerSize() {
        return 27;
    }

    static {
        FlowAnimator.Builder<CompactingChestBlockEntity> builder = new FlowAnimator.Builder<CompactingChestBlockEntity>(CompactingChestBlockEntity.class);
        builder.stateInfo(FlowStates.OPEN, 5);
        builder.stateInfo(FlowStates.ACTIVE, 20);
        builder.stateInfo(FlowStates.CLOSED, 14);
        builder.handle("piston", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).loopback(FlowStates.CLOSED).forStates(Float.valueOf(14.0f), FlowStates.OPEN).forStates(KeyFrame.sine(0.1f, 5.0f, 4.0f), FlowStates.ACTIVE).interpolate(Interpolation.CUBIC_IN).push();
        builder.handle("driver", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).loopback(FlowStates.CLOSED).forStates(Float.valueOf(6.0f), FlowStates.OPEN).forStates(KeyFrame.sine(0.1f, 5.0f, 5.0f, 13.0f), FlowStates.ACTIVE).interpolate(Interpolation.CUBIC_IN).push();
        builder.handle("cap", FlowHandlers.FLOAT).initial(Float.valueOf(0.0f)).loopback(FlowStates.CLOSED, FlowStates.ACTIVE).forStates(Float.valueOf(5.0f), FlowStates.OPEN).interpolate(Interpolation.CUBIC_IN).push();
        FACTORY = builder.build();
    }
}

