/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.bottomless_bundle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleBlock;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleBlockEntity;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BottomlessBundleBlockEntityRenderer
implements BlockEntityRenderer<BottomlessBundleBlockEntity> {
    private static final Material SPRITE = new Material(InventoryMenu.BLOCK_ATLAS, PastelCommon.locate("block/bottomless_bundle"));
    private final ModelPart root = BottomlessBundleBlockEntityRenderer.getTexturedModelData().bakeRoot();
    private final ModelPart locked = this.root.getChild("locked");
    private final ModelPart unlocked = this.root.getChild("unlocked");

    public BottomlessBundleBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(BottomlessBundleBlockEntity bundle, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        boolean bl = bundle.getLevel() != null;
        BlockState blockState = bl ? bundle.getBlockState() : ((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).defaultBlockState();
        float yaw = 22.5f;
        matrices.translate(0.5, 1.5, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees(-(yaw *= (float)((Integer)blockState.getValue((Property)SkullBlock.ROTATION)).intValue()) + 180.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        VertexConsumer vertices = SPRITE.buffer(vertexConsumers, RenderType::entityCutout);
        this.root.render(matrices, vertices, light, overlay);
        if (((Boolean)blockState.getValue((Property)BottomlessBundleBlock.LOCKED)).booleanValue()) {
            this.locked.render(matrices, vertices, light, overlay);
        } else {
            this.unlocked.render(matrices, vertices, light, overlay);
        }
        matrices.popPose();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition main = modelPartData.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition foot_r1 = main.addOrReplaceChild("foot_r1", CubeListBuilder.create().texOffs(13, 13).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition pyramid = main.addOrReplaceChild("pyramid", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)0.0f, (float)5.0f));
        PartDefinition side_r1 = pyramid.addOrReplaceChild("side_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.4423f, -4.7187f, -4.716f, 0.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.1358f, (float)-0.0429f, (float)-2.8923f, (float)1.9221f, (float)0.6819f, (float)2.5046f));
        PartDefinition side_r2 = pyramid.addOrReplaceChild("side_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-0.4423f, -4.7187f, -4.716f, 0.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0828f, (float)-0.0429f, (float)-7.188f, (float)2.7873f, (float)-0.674f, (float)2.5093f));
        PartDefinition side_r3 = pyramid.addOrReplaceChild("side_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-0.4423f, -4.7187f, -4.716f, 0.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9172f, (float)-0.0429f, (float)-2.812f, (float)-0.3543f, (float)0.674f, (float)0.6323f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -16.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)9.5f, (float)-0.5f));
        PartDefinition knot_r1 = head.addOrReplaceChild("knot_r1", CubeListBuilder.create().texOffs(9, 5).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-15.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)-0.0873f));
        PartDefinition cord_r1 = head.addOrReplaceChild("cord_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.25f, 0.05f, -2.825f, 5.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-14.5f, (float)0.25f, (float)0.6658f, (float)-0.1245f, (float)-0.8232f));
        PartDefinition top_r1 = head.addOrReplaceChild("top_r1", CubeListBuilder.create().texOffs(0, 4).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)-16.5f, (float)0.25f, (float)0.2618f, (float)0.7854f, (float)0.0f));
        PartDefinition locked = modelPartData.addOrReplaceChild("locked", CubeListBuilder.create(), PartPose.offset((float)-2.1358f, (float)18.9571f, (float)-2.1077f));
        PartDefinition s_locked_r1 = locked.addOrReplaceChild("s_locked_r1", CubeListBuilder.create().texOffs(0, 25).addBox(-0.4423f, -4.7187f, -4.716f, 0.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2195f, (float)-0.6819f, (float)0.637f));
        PartDefinition unlocked = modelPartData.addOrReplaceChild("unlocked", CubeListBuilder.create(), PartPose.offset((float)-2.1358f, (float)18.9571f, (float)-2.1077f));
        PartDefinition s_unlocked_r1 = unlocked.addOrReplaceChild("s_unlocked_r1", CubeListBuilder.create().texOffs(0, 15).addBox(-0.4423f, -4.7187f, -4.716f, 0.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.2195f, (float)-0.6819f, (float)0.637f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }
}

