/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.block_flooder;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.blocks.block_flooder.BlockFlooderBlockEntity;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public class BlockFlooderBlock
extends BaseEntityBlock {
    public static final MapCodec<BlockFlooderBlock> CODEC = BlockFlooderBlock.simpleCodec(BlockFlooderBlock::new);
    public static final HashMap<TagKey<Block>, Block> exchangeableBlocks = new HashMap<TagKey<Block>, Block>(){
        {
            this.put(BlockTags.DIRT, Blocks.DIRT);
            this.put(BlockTags.BASE_STONE_OVERWORLD, Blocks.STONE);
            this.put(BlockTags.BASE_STONE_NETHER, Blocks.NETHERRACK);
            this.put(BlockTags.SAND, Blocks.SAND);
        }
    };
    public static final List<TagKey<Block>> exchangeBlockTags = ImmutableList.copyOf(exchangeableBlocks.keySet());
    public final short MAX_DISTANCE = (short)10;
    public final BlockState DEFAULT_BLOCK_STATE = Blocks.COBBLESTONE.defaultBlockState();

    public BlockFlooderBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static boolean isReplaceableBlock(Level world, BlockPos blockPos) {
        BlockState state = world.getBlockState(blockPos);
        Block block = state.getBlock();
        return world.getBlockEntity(blockPos) == null && !(block instanceof BlockFlooderBlock) && (state.isAir() || block instanceof LiquidBlock || state.canBeReplaced() || block instanceof GrowingPlantBodyBlock || block instanceof FlowerBlock);
    }

    public static boolean isValidCornerBlock(Level world, BlockPos blockPos) {
        BlockState state = world.getBlockState(blockPos);
        Block block = state.getBlock();
        return state.isRedstoneConductor((BlockGetter)world, blockPos) || block instanceof LiquidBlock || block instanceof BlockFlooderBlock;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        if (!world.isClientSide) {
            world.scheduleTick(pos, state.getBlock(), 4);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockFlooderBlockEntity(pos, state);
    }

    private boolean calculateTargetBlockAndPropagate(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockFlooderBlockEntity) {
            BlockFlooderBlockEntity blockFlooderBlockEntity = (BlockFlooderBlockEntity)blockEntity;
            Player owner = PlayerOwned.getPlayerEntityIfOnline(blockFlooderBlockEntity.getOwnerUUID());
            if (owner == null) {
                world.setBlock(pos, this.DEFAULT_BLOCK_STATE, 3);
                return false;
            }
            HashMap<Block, Integer> neighboringBlockAmounts = new HashMap<Block, Integer>();
            for (Direction direction : Direction.values()) {
                BlockPos targetBlockPos = pos.relative(direction);
                BlockState currentBlockState = world.getBlockState(targetBlockPos);
                BlockEntity currentBlockEntity = world.getBlockEntity(targetBlockPos);
                if (currentBlockState.is((Block)this) || currentBlockEntity != null) continue;
                if (BlockFlooderBlock.isReplaceableBlock(world, targetBlockPos)) {
                    Vec3i nextPos = new Vec3i(targetBlockPos.relative(direction).getX(), targetBlockPos.relative(direction).getY(), targetBlockPos.relative(direction).getZ());
                    if (!blockFlooderBlockEntity.getSourcePos().closerThan(nextPos, 10.0) || !GenericClaimModsCompat.canPlaceBlock(world, targetBlockPos, (Entity)owner) || !this.shouldPropagateTo(world, targetBlockPos)) continue;
                    world.setBlock(targetBlockPos, state, 3);
                    BlockEntity blockEntity2 = world.getBlockEntity(targetBlockPos);
                    if (!(blockEntity2 instanceof BlockFlooderBlockEntity)) continue;
                    BlockFlooderBlockEntity neighboringBlockFlooderBlockEntity = (BlockFlooderBlockEntity)blockEntity2;
                    neighboringBlockFlooderBlockEntity.setOwnerUUID(blockFlooderBlockEntity.getOwnerUUID());
                    neighboringBlockFlooderBlockEntity.setSourcePos(blockFlooderBlockEntity.getSourcePos());
                    continue;
                }
                Block currentBlock = currentBlockState.getBlock();
                if (!currentBlockState.isRedstoneConductor((BlockGetter)world, targetBlockPos)) continue;
                if (neighboringBlockAmounts.containsKey(currentBlock)) {
                    neighboringBlockAmounts.put(currentBlock, (Integer)neighboringBlockAmounts.get(currentBlock) + 1);
                    continue;
                }
                neighboringBlockAmounts.put(currentBlock, 1);
            }
            if (!neighboringBlockAmounts.isEmpty()) {
                int max = 0;
                Block maxBlock = null;
                for (Map.Entry entry : neighboringBlockAmounts.entrySet()) {
                    Block currentBlock = (Block)entry.getKey();
                    int currentOccurrences = (Integer)entry.getValue();
                    Item blockItem = currentBlock.asItem();
                    if (blockItem == Items.AIR || currentOccurrences <= max && (currentOccurrences != max || !random.nextBoolean())) continue;
                    ItemStack currentItemStack = new ItemStack((ItemLike)blockItem);
                    if (owner.isCreative() || owner.getInventory().contains(currentItemStack) && currentBlock.defaultBlockState().canSurvive((LevelReader)world, pos)) {
                        maxBlock = currentBlock;
                        continue;
                    }
                    Optional<TagKey<Block>> tag = Support.getFirstMatchingBlockTag(currentBlock.defaultBlockState(), exchangeBlockTags);
                    if (!tag.isPresent() || (blockItem = (currentBlock = exchangeableBlocks.get(tag.get())).asItem()) == Items.AIR) continue;
                    currentItemStack = new ItemStack((ItemLike)blockItem);
                    if (!owner.isCreative() && (!owner.getInventory().contains(currentItemStack) || !currentBlock.defaultBlockState().canSurvive((LevelReader)world, pos))) continue;
                    maxBlock = currentBlock;
                }
                if (maxBlock != null) {
                    blockFlooderBlockEntity.setTargetBlockState(maxBlock.defaultBlockState());
                } else {
                    blockFlooderBlockEntity.setTargetBlockState(this.DEFAULT_BLOCK_STATE);
                }
            }
        }
        return true;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        super.tick(state, world, pos, random);
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof BlockFlooderBlockEntity) {
            BlockFlooderBlockEntity blockFlooderBlockEntity = (BlockFlooderBlockEntity)blockEntity;
            BlockState targetState = blockFlooderBlockEntity.getTargetBlockState();
            if (targetState == null || targetState.isAir()) {
                boolean scheduleUpdate = this.calculateTargetBlockAndPropagate(state, (Level)world, pos, world.getRandom());
                if (scheduleUpdate) {
                    world.scheduleTick(pos, state.getBlock(), 2 + random.nextInt(5));
                }
            } else {
                world.setBlock(pos, targetState, 3);
                Player owner = PlayerOwned.getPlayerEntityIfOnline(blockFlooderBlockEntity.getOwnerUUID());
                if (!owner.isCreative()) {
                    List<ItemStack> remainders = InventoryHelper.removeFromInventoryWithRemainders(new ItemStack((ItemLike)targetState.getBlock().asItem()), (IItemHandlerModifiable)new PlayerInvWrapper(owner.getInventory()));
                    for (ItemStack remainder : remainders) {
                        owner.getInventory().placeItemBackInInventory(remainder);
                    }
                }
            }
        }
    }

    private boolean shouldPropagateTo(Level world, BlockPos targetBlockPos) {
        if (BlockFlooderBlock.isReplaceableBlock(world, targetBlockPos)) {
            int count = 0;
            block0: for (Direction direction : Direction.values()) {
                for (int i = 1; i < 5; ++i) {
                    BlockPos offsetPos = targetBlockPos.relative(direction, i);
                    if (!BlockFlooderBlock.isValidCornerBlock(world, offsetPos)) continue;
                    ++count;
                    continue block0;
                }
            }
            return count >= 4;
        }
        return false;
    }
}

