/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.amalgam;

import earth.terrarium.pastel.api.item.DamageAwareItem;
import earth.terrarium.pastel.api.item.FermentedItem;
import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class IncandescentAmalgamItem
extends BlockItem
implements DamageAwareItem,
FermentedItem {
    public IncandescentAmalgamItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        ServerPlayer serverPlayerEntity;
        stack = super.finishUsingItem(stack, world, user);
        user.hurt(PastelDamageTypes.incandescence(world), 500.0f);
        float explosionPower = this.getExplosionPower(stack, false);
        world.explode((Entity)user, PastelDamageTypes.incandescence(world), (ExplosionDamageCalculator)new EntityBasedExplosionDamageCalculator((Entity)user), user.getX(), user.getEyeY(), user.getZ(), explosionPower, true, Level.ExplosionInteraction.BLOCK);
        if (user.isAlive() && user instanceof ServerPlayer && !(serverPlayerEntity = (ServerPlayer)user).isCreative()) {
            Support.grantAdvancementCriterion(serverPlayerEntity, "survive_drinking_incandescent_amalgam", "survived_drinking_incandescent_amalgam");
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"block.pastel.incandescent_amalgam.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"block.pastel.incandescent_amalgam.tooltip_power", (Object[])new Object[]{Float.valueOf(this.getExplosionPower(stack, false))}).withStyle(ChatFormatting.GRAY));
        if (FermentedItem.isPreviewStack(stack)) {
            tooltip.add((Component)Component.translatable((String)"block.pastel.incandescent_amalgam.tooltip.preview").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public void onItemEntityDamaged(DamageSource source, float amount, ItemEntity itemEntity) {
        ItemStack stack = itemEntity.getItem();
        itemEntity.remove(Entity.RemovalReason.KILLED);
        float explosionPower = this.getExplosionPower(stack, true);
        Level world = itemEntity.level();
        world.explode((Entity)itemEntity, PastelDamageTypes.incandescence(world, (Entity)itemEntity), (ExplosionDamageCalculator)new EntityBasedExplosionDamageCalculator((Entity)itemEntity), itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), explosionPower, true, Level.ExplosionInteraction.BLOCK);
    }

    public float getExplosionPower(ItemStack stack, boolean useCount) {
        float alcPercent = ((BeverageComponent)stack.getOrDefault(PastelDataComponentTypes.BEVERAGE, (Object)BeverageComponent.DEFAULT)).alcoholPercent();
        return alcPercent <= 0.0f ? 6.0f : alcPercent * (useCount ? 0.875f + (float)stack.getCount() / 8.0f : 1.0f);
    }
}

