/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.recipe.primordial_fire_burning.PrimordialFireBurningRecipe;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PrimordialFireBlock
extends BaseFireBlock {
    public static final MapCodec<PrimordialFireBlock> CODEC = PrimordialFireBlock.simpleCodec(PrimordialFireBlock::new);
    public static boolean EXPLOSION_CAUSES_PRIMORDIAL_FIRE_FLAG = false;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    private static final Map<Direction, BooleanProperty> DIRECTION_PROPERTIES = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.toMap());
    private static final VoxelShape UP_SHAPE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesByState;
    private static final float DAMAGE = 0.2f;

    public PrimordialFireBlock(BlockBehaviour.Properties settings) {
        super(settings, 0.2f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), PrimordialFireBlock::getShapeForState)));
    }

    public MapCodec<? extends PrimordialFireBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP});
    }

    public static VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelShape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)WEST_SHAPE);
        }
        return voxelShape.isEmpty() ? DOWN_AABB : voxelShape;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)world, pos) ? this.getStateForPosition((BlockGetter)world, pos) : Blocks.AIR.defaultBlockState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapesByState.get(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getStateForPosition((BlockGetter)ctx.getLevel(), ctx.getClickedPos());
    }

    public BlockState getStateForPosition(BlockGetter world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        if (!this.canBurn(blockState) && !blockState.isFaceSturdy(world, blockPos, Direction.UP)) {
            BlockState blockState2 = this.defaultBlockState();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanProperty = DIRECTION_PROPERTIES.get(direction);
                if (booleanProperty == null) continue;
                blockState2 = (BlockState)blockState2.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(this.canBurn(world.getBlockState(pos.relative(direction)))));
            }
            return blockState2;
        }
        return this.defaultBlockState();
    }

    public static boolean tryPlacePrimordialFire(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos);
        if (PrimordialFireBlock.canBePlacedAt((Level)world, (BlockPos)pos, (Direction)direction)) {
            if (world.setBlockAndUpdate(pos, ((PrimordialFireBlock)((Object)PastelBlocks.PRIMORDIAL_FIRE.get())).getStateForPosition((BlockGetter)world, pos))) {
                world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, pos);
                return true;
            }
        } else {
            if (!(CampfireBlock.canLight((BlockState)state) || CandleBlock.canLight((BlockState)state) || CandleCakeBlock.canLight((BlockState)state))) {
                if (state.getBlock() instanceof TntBlock) {
                    TntBlock.explode((Level)world, (BlockPos)pos);
                    world.removeBlock(pos, false);
                    return true;
                }
                return false;
            }
            if (world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)))) {
                world.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return true;
            }
        }
        return false;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entity.hurt(PastelDamageTypes.primordialFire(world, null), 0.2f);
            PrimordialFireData.addPrimordialFireTicks(livingEntity, 5);
        }
        if (world.getGameTime() % 20L == 0L && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            PrimordialFireBurningRecipe.processItemEntity(world, itemEntity);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.below();
        return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, Direction.UP) || this.areBlocksAroundFlammable((BlockGetter)world, pos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.scheduleTick(pos, (Block)this, PrimordialFireBlock.getFireTickDelay(world.random));
        if (world.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            BlockState blockState;
            boolean isAboveInfiniburnBlock;
            if (!state.canSurvive((LevelReader)world, pos)) {
                world.removeBlock(pos, false);
            }
            boolean bl = isAboveInfiniburnBlock = (blockState = world.getBlockState(pos.below())).is(world.dimensionType().infiniburn()) || blockState.is(PastelBlockTags.PRIMORDIAL_FIRE_BASE_BLOCKS);
            if (!isAboveInfiniburnBlock && random.nextFloat() < 0.01f) {
                world.removeBlock(pos, false);
            } else {
                if (!isAboveInfiniburnBlock && !this.areBlocksAroundFlammable((BlockGetter)world, pos)) {
                    BlockPos blockPos = pos.below();
                    if (!world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, Direction.UP)) {
                        world.removeBlock(pos, false);
                    }
                    if (random.nextInt(10) == 0 && !this.canBurn(world.getBlockState(pos.below()))) {
                        world.removeBlock(pos, false);
                        return;
                    }
                    return;
                }
                boolean biomeHasIncreasedFireBurnout = world.getBiome(pos).is(BiomeTags.INCREASED_FIRE_BURNOUT);
                int spreadReduction = biomeHasIncreasedFireBurnout ? -50 : 0;
                this.trySpreadingFire((Level)world, pos.east(), 300 + spreadReduction, random, Direction.WEST);
                this.trySpreadingFire((Level)world, pos.west(), 300 + spreadReduction, random, Direction.EAST);
                this.trySpreadingFire((Level)world, pos.below(), 250 + spreadReduction, random, Direction.UP);
                this.trySpreadingFire((Level)world, pos.above(), 250 + spreadReduction, random, Direction.DOWN);
                this.trySpreadingFire((Level)world, pos.north(), 300 + spreadReduction, random, Direction.SOUTH);
                this.trySpreadingFire((Level)world, pos.south(), 300 + spreadReduction, random, Direction.NORTH);
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int y = -1; y <= 4; ++y) {
                            int q;
                            if (x == 0 && y == 0 && z == 0) continue;
                            int o = 100;
                            if (y > 1) {
                                o += (y - 1) * 100;
                            }
                            mutable.setWithOffset((Vec3i)pos, x, y, z);
                            int burnChance = this.getBurnChance((LevelReader)world, (BlockPos)mutable);
                            if (burnChance <= 0 || (q = (burnChance + 40 + world.getDifficulty().getId() * 7) / 30) <= 0 || random.nextInt(o) > q) continue;
                            world.setBlock((BlockPos)mutable, this.getStateForPosition((BlockGetter)world, (BlockPos)mutable), 3);
                        }
                    }
                }
            }
        }
    }

    private void trySpreadingFire(Level world, BlockPos pos, int spreadFactor, RandomSource random, Direction direction) {
        if (!GenericClaimModsCompat.canBreak(world, pos, null)) {
            return;
        }
        int spreadChance = world.getBlockState(pos).getFlammability((BlockGetter)world, pos, direction);
        if (random.nextInt(spreadFactor) < spreadChance) {
            BlockState currentState = world.getBlockState(pos);
            if (random.nextBoolean()) {
                if (PrimordialFireBurningRecipe.processBlock(world, pos, currentState)) {
                    return;
                }
                world.setBlock(pos, this.getStateForPosition((BlockGetter)world, pos), 3);
            }
            if (currentState.getBlock() instanceof TntBlock) {
                TntBlock.explode((Level)world, (BlockPos)pos);
            }
        }
    }

    private boolean areBlocksAroundFlammable(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canBurn(world.getBlockState(pos.relative(direction)))) continue;
            return true;
        }
        return false;
    }

    private int getBurnChance(LevelReader world, BlockPos pos) {
        if (!world.isEmptyBlock(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockState = world.getBlockState(pos.relative(direction));
            i = Math.max(blockState.getFireSpreadSpeed((BlockGetter)world, pos, direction.getOpposite()), i);
        }
        return i;
    }

    protected boolean canBurn(BlockState state) {
        return ((FireBlock)Blocks.FIRE).getIgniteOdds(state) > 0;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.onPlace(state, world, pos, oldState, notify);
        world.scheduleTick(pos, (Block)this, PrimordialFireBlock.getFireTickDelay(world.random));
    }

    private static int getFireTickDelay(RandomSource random) {
        return 20 + random.nextInt(10);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        block14: {
            double f;
            double e;
            double d;
            int i;
            block13: {
                BlockPos blockPos;
                BlockState blockState;
                if (random.nextInt(24) == 0) {
                    world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PastelSounds.PRIMORDIAL_FIRE_CRACKLE, SoundSource.BLOCKS, 0.175f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
                }
                if ((blockState = world.getBlockState(blockPos = pos.below())).isFaceSturdy((BlockGetter)world, blockPos, Direction.UP)) {
                    SimpleParticleType particle = this.canBurn(blockState) ? PastelParticleTypes.PRIMORDIAL_SIGNAL_SMOKE : PastelParticleTypes.PRIMORDIAL_COSY_SMOKE;
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1);
                        e = (double)pos.getY() + 0.15;
                        f = (double)pos.getZ() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1);
                        world.addParticle((ParticleOptions)particle, d, e, f, 0.0015, 0.07, 0.0015);
                    }
                }
                if (this.canBurn(blockState) || blockState.isFaceSturdy((BlockGetter)world, blockPos, Direction.UP)) break block13;
                if (this.canBurn(world.getBlockState(pos.west()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + random.nextDouble() * (double)0.1f;
                        e = (double)pos.getY() + random.nextDouble();
                        f = (double)pos.getZ() + random.nextDouble();
                        world.addParticle((ParticleOptions)PastelParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(pos.east()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)(pos.getX() + 1) - random.nextDouble() * (double)0.1f;
                        e = (double)pos.getY() + random.nextDouble();
                        f = (double)pos.getZ() + random.nextDouble();
                        world.addParticle((ParticleOptions)PastelParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(pos.north()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + random.nextDouble();
                        e = (double)pos.getY() + random.nextDouble();
                        f = (double)pos.getZ() + random.nextDouble() * (double)0.1f;
                        world.addParticle((ParticleOptions)PastelParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canBurn(world.getBlockState(pos.south()))) {
                    for (i = 0; i < 2; ++i) {
                        d = (double)pos.getX() + random.nextDouble();
                        e = (double)pos.getY() + random.nextDouble();
                        f = (double)(pos.getZ() + 1) - random.nextDouble() * (double)0.1f;
                        world.addParticle((ParticleOptions)PastelParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canBurn(world.getBlockState(pos.above()))) break block14;
                for (i = 0; i < 2; ++i) {
                    d = (double)pos.getX() + random.nextDouble();
                    e = (double)(pos.getY() + 1) - random.nextDouble() * (double)0.1f;
                    f = (double)pos.getZ() + random.nextDouble();
                    world.addParticle((ParticleOptions)PastelParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
                }
                break block14;
            }
            for (i = 0; i < 3; ++i) {
                d = (double)pos.getX() + random.nextDouble();
                e = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
                f = (double)pos.getZ() + random.nextDouble();
                world.addParticle((ParticleOptions)PastelParticleTypes.PRIMORDIAL_SMOKE, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_FIRE;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_FIRE;
    }
}

