/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import earth.terrarium.pastel.blocks.crystallarieum.PastelClusterBlock;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BismuthBudBlock
extends PastelClusterBlock {
    public static final int GROWTH_CHECK_RADIUS = 3;
    public static final int GROWTH_CHECK_TRIES = 5;
    public static final TagKey<Block> CONSUMED_TAG_TO_GROW = BlockTags.BEACON_BASE_BLOCKS;
    public static final BlockState CONSUMED_TARGET_STATE = Blocks.COBBLESTONE.defaultBlockState();
    public final AmethystClusterBlock grownBlock;

    public BismuthBudBlock(BlockBehaviour.Properties settings, PastelClusterBlock.GrowthStage growthStage, @Nullable Block grownBlock) {
        super(settings, growthStage);
        this.grownBlock = (AmethystClusterBlock)grownBlock;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (!world.isClientSide && this.grownBlock != null && BismuthBudBlock.searchAndConsumeBlock((Level)world, pos, 3, CONSUMED_TAG_TO_GROW, CONSUMED_TARGET_STATE, 5, random)) {
            BlockState newState = (BlockState)((BlockState)this.grownBlock.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            world.setBlockAndUpdate(pos, newState);
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CHAIN_PLACE, SoundSource.BLOCKS, 0.8f, 0.9f + random.nextFloat() * 0.2f);
            Vec3 sourcePos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + (double)this.growthStage.height / 16.0, (double)pos.getZ() + 0.5);
            Vec3 randomOffset = new Vec3(0.25, (double)this.growthStage.height / 32.0, 0.25);
            Vec3 randomVelocity = new Vec3(0.1, 0.1, 0.1);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, sourcePos, ColoredCraftingParticleEffect.WHITE, 2, randomOffset, randomVelocity);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, sourcePos, ColoredCraftingParticleEffect.LIME, 2, randomOffset, randomVelocity);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, sourcePos, ColoredCraftingParticleEffect.PURPLE, 2, randomOffset, randomVelocity);
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, sourcePos, ColoredCraftingParticleEffect.ORANGE, 2, randomOffset, randomVelocity);
        }
    }

    public static boolean searchAndConsumeBlock(Level world, BlockPos pos, int radius, TagKey<Block> tagKey, BlockState targetState, int tries, RandomSource random) {
        for (int i = 0; i < tries; ++i) {
            BlockPos offsetPos = pos.offset(radius - random.nextInt(1 + radius + radius), radius - random.nextInt(1 + radius + radius), radius - random.nextInt(1 + radius + radius));
            BlockState offsetState = world.getBlockState(offsetPos);
            if (!offsetState.is(tagKey)) continue;
            world.setBlockAndUpdate(offsetPos, targetState);
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), offsetState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 0.8f, 0.9f + random.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }
}

