/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ActionableBlockEntity
extends BlockEntity {
    protected FriendlyStackHandler inventory;
    private final int invSize;

    public ActionableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, int size, boolean listen) {
        super(type, pos, blockState);
        this.invSize = size;
        if (size == -1) {
            return;
        }
        this.inventory = new FriendlyStackHandler(size);
        if (listen) {
            this.inventory.addListener(i -> this.inventoryChanged());
        }
    }

    public ActionableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, int size) {
        this(type, pos, blockState, size, false);
    }

    public void inventoryChanged() {
        assert (this.level != null);
        if (this.level.isClientSide()) {
            return;
        }
        this.setChanged();
    }

    public void updateInClientWorld() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.inventory == null) {
            return;
        }
        CompoundTag inner = new CompoundTag();
        this.inventory.save(inner, registries);
        tag.put("inventory", (Tag)inner);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.invSize >= 0 && tag.contains("inventory")) {
            this.inventory.load(tag.getCompound("inventory"), registries);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }
}

