/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data.azure_dike;

import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeData;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class AzureDikeProvider {
    public static float absorbDamage(LivingEntity provider, float incomingDamage) {
        AzureDikeData azureDike = (AzureDikeData)provider.getData(AzureDikeData.ATTACHMENT);
        float passedDamage = azureDike.absorbDamage(incomingDamage);
        if (incomingDamage - passedDamage > 1.0E-4f) {
            AttachmentUtil.syncToTracking(new AzureDikeData.Payload(provider.getId(), azureDike), provider.level(), provider.blockPosition());
            if (provider instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)provider;
                PastelCriteria.AZURE_DIKE_CHARGE.trigger(player, azureDike.getCurrentProtection(), azureDike.getTicksPerPointOfRecharge(), -(incomingDamage - passedDamage));
            }
        }
        if (PastelTrinketItem.hasEquipped(provider, (Item)PastelItems.AZURESQUE_DIKE_CORE.get())) {
            return passedDamage * 2.0f;
        }
        return passedDamage;
    }

    public static float getAzureDikeCharges(LivingEntity provider) {
        return ((AzureDikeData)provider.getData(AzureDikeData.ATTACHMENT)).getCurrentProtection();
    }

    public static float getMaxAzureDikeCharges(LivingEntity provider) {
        return ((AzureDikeData)provider.getData(AzureDikeData.ATTACHMENT)).getMaxProtection();
    }

    public static AzureDikeData getAzureDikeComponent(LivingEntity provider) {
        return (AzureDikeData)provider.getData(AzureDikeData.ATTACHMENT);
    }
}

