/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data.azure_dike;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import earth.terrarium.pastel.attachments.data.azure_dike.DikeShieldData;
import earth.terrarium.pastel.progression.PastelCriteria;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class AzureDikeData
implements DikeShieldData {
    public static final Codec<AzureDikeData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("maxProt").forGetter(AzureDikeData::getMaxProtection), (App)Codec.FLOAT.fieldOf("currentProt").forGetter(AzureDikeData::getCurrentProtection), (App)Codec.INT.fieldOf("rechargeTicks").forGetter(AzureDikeData::getTicksPerPointOfRecharge), (App)Codec.INT.fieldOf("rechargeDelayPostHit").forGetter(AzureDikeData::getRechargeDelayTicksAfterGettingHit), (App)Codec.INT.fieldOf("rechargeDelay").forGetter(AzureDikeData::getCurrentRechargeDelay)).apply((Applicative)i, AzureDikeData::new));
    public static final IAttachmentCopyHandler<AzureDikeData> CLONER = (dike, holder, provider) -> {
        AzureDikeData newDike = new AzureDikeData();
        newDike.maxProt = dike.maxProt;
        newDike.rechargeTicks = dike.rechargeTicks;
        newDike.rechargeDelayPostTick = dike.rechargeDelayPostTick;
        return newDike;
    };
    public static final AttachmentType<AzureDikeData> ATTACHMENT = AttachmentType.builder(AzureDikeData::new).serialize(CODEC).copyOnDeath().copyHandler(CLONER).build();
    public static final int BASE_RECHARGE_DELAY_TICKS = 40;
    public static final int BASE_RECHARGE_DELAY_TICKS_AFTER_DAMAGE = 200;
    private float maxProt = 0.0f;
    private int rechargeTicks = 0;
    private int rechargeDelayPostTick = 0;
    private float currentProt = 0.0f;
    private int rechargeDelay = 0;

    public AzureDikeData() {
    }

    public AzureDikeData(float maxProt, float currentProt, int rechargeTicks, int rechargeDelayPostTick, int rechargeDelay) {
        this.maxProt = maxProt;
        this.rechargeTicks = rechargeTicks;
        this.rechargeDelayPostTick = rechargeDelayPostTick;
        this.currentProt = currentProt;
        this.rechargeDelay = rechargeDelay;
    }

    @Override
    public float getCurrentProtection() {
        return this.currentProt;
    }

    @Override
    public float getMaxProtection() {
        return this.maxProt;
    }

    @Override
    public int getTicksPerPointOfRecharge() {
        return this.rechargeTicks;
    }

    @Override
    public int getCurrentRechargeDelay() {
        return this.rechargeDelay;
    }

    @Override
    public int getRechargeDelayTicksAfterGettingHit() {
        return this.rechargeDelayPostTick;
    }

    @Override
    public float absorbDamage(float incomingDamage) {
        if (incomingDamage == 0.0f) {
            return 0.0f;
        }
        this.rechargeDelay = this.rechargeDelayPostTick;
        if (this.currentProt > 0.0f) {
            float absorbedDamage = Math.min(this.currentProt, incomingDamage);
            this.currentProt -= absorbedDamage;
            return incomingDamage - absorbedDamage;
        }
        return incomingDamage;
    }

    @Override
    public void set(float maxProtection, int rechargeDelayDefault, int fasterRechargeAfterDamageTicks, boolean resetCharge) {
        this.maxProt = maxProtection;
        this.rechargeTicks = rechargeDelayDefault;
        this.rechargeDelayPostTick = fasterRechargeAfterDamageTicks;
        this.rechargeDelay = this.rechargeTicks;
        this.currentProt = resetCharge ? 0.0f : Math.min(this.currentProt, this.maxProt);
    }

    public void serverTick(LivingEntity provider) {
        if (this.rechargeDelay > 0) {
            --this.rechargeDelay;
        } else if (this.currentProt < this.maxProt) {
            this.currentProt = Math.min(this.maxProt, this.currentProt + 1.0f);
            this.rechargeDelay = this.rechargeTicks;
            this.sync(provider);
            if (provider instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)provider;
                PastelCriteria.AZURE_DIKE_CHARGE.trigger(serverPlayerEntity, this.currentProt, this.rechargeTicks, 1.0f);
            }
        }
    }

    public void sync(LivingEntity provider) {
        AttachmentUtil.syncToTracking(new Payload(provider.getId(), this), provider.level(), provider.blockPosition());
    }

    public record Payload(int entityId, float maxProt, float currentProt, int rechargeTicks, int rechargeDelayPostTick, int rechargeDelay) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Payload::entityId, (StreamCodec)ByteBufCodecs.FLOAT, Payload::maxProt, (StreamCodec)ByteBufCodecs.FLOAT, Payload::currentProt, (StreamCodec)ByteBufCodecs.INT, Payload::rechargeTicks, (StreamCodec)ByteBufCodecs.INT, Payload::rechargeDelayPostTick, (StreamCodec)ByteBufCodecs.INT, Payload::rechargeDelay, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("dike");

        public Payload(int entityId, AzureDikeData attachment) {
            this(entityId, attachment.maxProt, attachment.currentProt, attachment.rechargeTicks, attachment.rechargeDelayPostTick, attachment.rechargeDelay);
        }

        public static void execute(Payload payload, IPayloadContext context) {
            Level level = context.player().level();
            Optional.ofNullable(level.getEntity(payload.entityId)).ifPresent(e -> e.setData(ATTACHMENT, (Object)new AzureDikeData(payload.maxProt, payload.currentProt, payload.rechargeTicks, payload.rechargeDelayPostTick(), payload.rechargeDelay)));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

