/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import earth.terrarium.pastel.sound.OnPrimordialFireSoundInstance;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PrimordialFireData {
    public static final AttachmentType<Long> ATTACHMENT = AttachmentType.builder(() -> 0L).serialize((Codec)Codec.LONG).build();
    public static final float BASE_PERCENT_DAMAGE = 0.01f;
    public static final float FIRE_RESISTANCE_DAMAGE_RESISTANCE = 0.25f;
    public static final float FIRE_PROT_DAMAGE_RESISTANCE = 0.05f;
    @OnlyIn(value=Dist.CLIENT)
    public static OnPrimordialFireSoundInstance soundInstance;

    private static void sync(LivingEntity entity) {
        AttachmentUtil.syncToTracking(new Payload(entity.getId(), (Long)entity.getData(ATTACHMENT)), entity.level(), entity.blockPosition());
    }

    public static void setPrimordialFireTicks(LivingEntity entity, long ticks) {
        entity.setData(ATTACHMENT, (Object)ticks);
        PrimordialFireData.sync(entity);
    }

    public static void addPrimordialFireTicks(LivingEntity entity, int ticks) {
        int i = Ench.getEquipmentLevel((HolderLookup.Provider)entity.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, entity);
        if (i > 0) {
            ticks -= Mth.floor((float)((float)(ticks * i) * 0.15f));
        }
        entity.setData(ATTACHMENT, (Object)((Long)entity.getData(ATTACHMENT) + (long)ticks));
        PrimordialFireData.sync(entity);
    }

    public static boolean isOnPrimordialFire(LivingEntity entity) {
        return (Long)entity.getData(ATTACHMENT) > 0L;
    }

    public static boolean putOut(LivingEntity entity) {
        if ((Long)entity.getData(ATTACHMENT) == 0L) {
            return false;
        }
        entity.setData(ATTACHMENT, (Object)0L);
        PrimordialFireData.sync(entity);
        return true;
    }

    public static void serverTick(LivingEntity entity) {
        long primordialFireTicks = (Long)entity.getData(ATTACHMENT);
        if (primordialFireTicks == 0L) {
            return;
        }
        if (entity.getType().is(PastelEntityTypeTags.PRIMORDIAL_FIRE_IMMUNE)) {
            entity.setData(ATTACHMENT, (Object)0L);
            return;
        }
        if (!PrimordialFireData.isAffectingConstruct(entity)) {
            float damageScaling = PrimordialFireData.getDamageHealthScaling(entity);
            entity.hurt(PastelDamageTypes.primordialFire(entity.level()), AzureDikeProvider.absorbDamage(entity, damageScaling * entity.getMaxHealth()));
        } else if (entity.tickCount % 10 == 0) {
            entity.hurt(PastelDamageTypes.primordialFire(entity.level()), 1.0f);
        }
        entity.setData(ATTACHMENT, (Object)(primordialFireTicks -= entity.getFluidHeight(FluidTags.WATER) > 0.0 ? 3L : 1L));
        if (primordialFireTicks <= 0L) {
            PrimordialFireData.sync(entity);
        }
    }

    public static boolean isAffectingConstruct(LivingEntity entity) {
        return entity.getType().is(PastelEntityTypeTags.SOULLESS);
    }

    public static float getDamageHealthScaling(LivingEntity entity) {
        float baseDamage = 0.01f;
        if (entity.getType().is(Tags.EntityTypes.BOSSES)) {
            baseDamage /= 20.0f;
        }
        return baseDamage * PrimordialFireData.getDamagePenalties(entity) * PrimordialFireData.getDamageBonuses(entity);
    }

    public static float getDamagePenalties(LivingEntity entity) {
        float fireProt = Math.min(0.05f * (float)Ench.getEquipmentLevel((HolderLookup.Provider)entity.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, entity), 0.5f);
        int fireResLevel = Optional.ofNullable(entity.getEffect(MobEffects.FIRE_RESISTANCE)).map(MobEffectInstance::getAmplifier).orElse(-1) + 1;
        float fireRes = 0.0f;
        if (fireResLevel > 0) {
            fireRes = 0.25f;
        }
        for (int i = 1; i < fireResLevel; ++i) {
            fireRes += (float)(0.05 * (double)i + 0.25 * Math.pow(0.5, i));
        }
        float immunityReduction = entity.fireImmune() ? 0.25f : 0.0f;
        return Math.max(1.0f - (fireRes + fireProt + immunityReduction), 0.1f);
    }

    public static float getDamageBonuses(LivingEntity entity) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(LivingEntity entity) {
        Long primordialFireTicks = (Long)entity.getData(ATTACHMENT);
        if (primordialFireTicks > 0L) {
            double fluidHeight;
            if (entity.equals((Object)Minecraft.getInstance().player) && primordialFireTicks > 2L && soundInstance == null) {
                soundInstance = new OnPrimordialFireSoundInstance((Player)entity);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)soundInstance);
            }
            if ((fluidHeight = entity.getFluidHeight(FluidTags.WATER)) > 0.0) {
                Level world = entity.level();
                RandomSource random = world.random;
                Vec3 pos = entity.position();
                for (int i = 0; i < 2; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, entity.getRandomX(1.0), pos.y() + Math.min(fluidHeight, (double)entity.getBbHeight()) * (double)random.nextFloat(), entity.getRandomZ(1.0), 0.0, 0.04, 0.0);
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, entity.getRandomX(1.0), pos.y() + Math.min(fluidHeight, (double)entity.getBbHeight()) * (double)random.nextFloat(), entity.getRandomZ(1.0), 0.0, 0.04, 0.0);
                }
                if (world.random.nextInt(12) == 0) {
                    entity.playSound(SoundEvents.FIRE_EXTINGUISH, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f);
                }
            }
        } else if (entity.equals((Object)Minecraft.getInstance().player) && soundInstance != null) {
            soundInstance = null;
        }
    }

    public record Payload(int entityId, long burnTicks) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Payload::entityId, (StreamCodec)ByteBufCodecs.VAR_LONG, Payload::burnTicks, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("primfire");

        public static void execute(Payload payload, IPayloadContext context) {
            Level level = context.player().level();
            Optional.ofNullable(level.getEntity(payload.entityId)).ifPresent(e -> e.setData(ATTACHMENT, (Object)payload.burnTicks));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

