/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data;

import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class InertiaData {
    public static final AttachmentType<InertiaData> ATTACHMENT = AttachmentType.builder(h -> new InertiaData((Player)h)).build();
    private static final int CAP = 36;
    private final Player holder;
    private Optional<Block> currentTarget = Optional.empty();
    private int stacks = 0;
    private float strength;
    private float lastStrength;
    private long minedTimeStamp;

    public InertiaData(Player holder) {
        this.holder = holder;
    }

    public float getPotency(boolean client) {
        if (client) {
            return this.strength;
        }
        this.strength = (float)Math.min(this.stacks, 36) / 36.0f;
        return this.strength;
    }

    public void record(BlockState state, long time, int inertia) {
        if (time - 120L > this.minedTimeStamp && this.currentTarget.isPresent()) {
            this.currentTarget = Optional.empty();
            this.stacks = 0;
            this.strength = 0.0f;
            this.sync();
            return;
        }
        if (this.stacks == 0) {
            this.currentTarget = Optional.of(state.getBlock());
        }
        if (this.currentTarget.map(arg_0 -> ((BlockState)state).is(arg_0)).orElse(false).booleanValue()) {
            if ((double)this.stacks < 36.0 + Math.pow(inertia, 1.5) + 2.0) {
                this.stacks += (inertia - 1) / 2 + 1;
            }
        } else if (this.stacks > 0) {
            --this.stacks;
        }
        this.minedTimeStamp = time;
        this.strength = this.getPotency(false);
        this.sync();
    }

    public static void tick(Player player) {
        InertiaData data = (InertiaData)player.getData(ATTACHMENT);
        data.tickInner(player);
    }

    private void tickInner(Player player) {
        long time = player.level().getGameTime();
        if (time - 10L > this.minedTimeStamp && this.stacks > 0) {
            --this.stacks;
            if (this.stacks == 0) {
                this.currentTarget = Optional.empty();
                this.strength = 0.0f;
            }
        }
        if (!Mth.equal((float)this.strength, (float)this.lastStrength) && player instanceof ServerPlayer) {
            this.sync();
        }
        this.lastStrength = this.strength;
    }

    public void sync() {
        AttachmentUtil.syncToPlayer(new Payload(this.strength, this.minedTimeStamp), this.holder);
    }

    public record Payload(float strength, long timeStamp) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, Payload::strength, (StreamCodec)ByteBufCodecs.VAR_LONG, Payload::timeStamp, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("inertia");

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void execute(Payload payload, IPayloadContext context) {
            InertiaData data = (InertiaData)context.player().getData(ATTACHMENT);
            data.strength = payload.strength;
            data.minedTimeStamp = payload.timeStamp();
        }
    }
}

