/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class EverpromiseRibbonData {
    public static final AttachmentType<Boolean> ATTACHMENT = AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).build();

    public static void attachRibbon(LivingEntity livingEntity) {
        livingEntity.setData(ATTACHMENT, (Object)true);
    }

    public static boolean hasRibbon(LivingEntity livingEntity) {
        return (Boolean)livingEntity.getData(ATTACHMENT);
    }

    public record Payload(int entityId, boolean ribbon) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Payload::entityId, (StreamCodec)ByteBufCodecs.BOOL, Payload::ribbon, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("ribbon");

        public static void execute(Payload payload, IPayloadContext context) {
            Level level = context.player().level();
            Optional.ofNullable(level.getEntity(payload.entityId)).ifPresent(e -> e.setData(ATTACHMENT, (Object)payload.ribbon));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

