/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.recipe;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.progression.UnlockToastManager;
import java.util.Optional;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public interface GatedRecipe<C extends RecipeInput>
extends Recipe<C> {
    public boolean isSecret();

    public Optional<ResourceLocation> advancementID();

    public ResourceLocation typeAdvancementID();

    public String getRecipeTypeShortID();

    default public boolean canPlayerCraft(Player playerEntity) {
        if (!DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)this.typeAdvancementID())) {
            return false;
        }
        Optional<ResourceLocation> advancement = this.advancementID();
        return advancement.map(adv -> DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)adv)).orElse(true);
    }

    default public Component getSingleUnlockToastString() {
        return Component.translatable((String)("pastel.toast." + this.getRecipeTypeShortID() + "_recipe_unlocked.title"));
    }

    default public Component getMultipleUnlockToastString() {
        return Component.translatable((String)("pastel.toast." + this.getRecipeTypeShortID() + "_recipes_unlocked.title"));
    }

    default public void registerInToastManager(RecipeType<?> recipeType, GatedRecipe<C> gatedRecipe) {
        if (FMLLoader.getDist().isClient()) {
            this.registerInToastManagerClient(recipeType, gatedRecipe);
        }
    }

    private void registerInToastManagerClient(RecipeType<?> recipeType, GatedRecipe<C> gatedRecipe) {
        UnlockToastManager.registerGatedRecipe(recipeType, gatedRecipe);
    }

    @Nullable
    default public Component getSecretHintText(ResourceLocation id) {
        if (this.isSecret()) {
            String secretHintLangKey = id.toLanguageKey("recipe", "hint").replace("/", ".");
            return Language.getInstance().has(secretHintLangKey) ? Component.translatable((String)secretHintLangKey) : null;
        }
        return null;
    }
}

