/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.predicate.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record BrokenBlockPredicate(Optional<HolderSet<Block>> blocks, Optional<StatePropertiesPredicate> state) {
    public static final Codec<BrokenBlockPredicate> CODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("blocks").forGetter(BrokenBlockPredicate::blocks), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(BrokenBlockPredicate::state)).apply((Applicative)i, BrokenBlockPredicate::new));

    public boolean test(BlockState state) {
        if (this.blocks.isPresent() && !state.is(this.blocks.get())) {
            return false;
        }
        return this.state.isEmpty() || this.state.get().matches(state);
    }

    public static class Builder {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<StatePropertiesPredicate> state = Optional.empty();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder blocks(Block ... blocks) {
            this.blocks = Optional.of(HolderSet.direct(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).wrapAsHolder(arg_0), (Object[])blocks));
            return this;
        }

        public Builder blocks(Iterable<Block> blocks) {
            ArrayList<Holder> blockEntries = new ArrayList<Holder>();
            for (Block block : blocks) {
                blockEntries.add(BuiltInRegistries.BLOCK.wrapAsHolder((Object)block));
            }
            this.blocks = Optional.of(HolderSet.direct(blockEntries));
            return this;
        }

        public Builder tag(TagKey<Block> tag) {
            this.blocks = BuiltInRegistries.BLOCK.getTag(tag).map(l -> l);
            return this;
        }

        public Builder registryEntryList(HolderSet<Block> list) {
            this.blocks = Optional.of(list);
            return this;
        }

        public Builder state(StatePropertiesPredicate state) {
            this.state = Optional.of(state);
            return this;
        }

        public BrokenBlockPredicate build() {
            return new BrokenBlockPredicate(this.blocks, this.state);
        }
    }
}

