/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface SplitDamageHandler {
    public DamageComposition getDamageComposition(LivingEntity var1, LivingEntity var2, ItemStack var3, float var4);

    public record Partition(DamageSource source, float damage) {
    }

    public static class DamageComposition {
        private final List<Partition> partitions = new ArrayList<Partition>();

        public void addPlayerOrEntity(LivingEntity entity, float damage) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.partitions.add(new Partition(player.damageSources().playerAttack(player), damage));
            } else {
                this.partitions.add(new Partition(entity.damageSources().mobAttack(entity), damage));
            }
        }

        public DamageSource getPlayerOrEntity(LivingEntity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return player.damageSources().playerAttack(player);
            }
            return entity.damageSources().mobAttack(entity);
        }

        public void add(DamageSource damageSource, float damage) {
            this.partitions.add(new Partition(damageSource, damage));
        }

        public List<Partition> get() {
            return this.partitions;
        }
    }
}

