/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BannerPattern;

public interface LoomPatternProvider {
    public static final Component PATTERN_AVAILABLE_TOOLTIP_TEXT = Component.translatable((String)"item.pastel.tooltip.loom_pattern_available").withStyle(ChatFormatting.GRAY);

    public ResourceKey<BannerPattern> getPattern();

    public static ImmutableList<Holder<BannerPattern>> getPatterns(HolderGetter<BannerPattern> lookup, LoomPatternProvider provider) {
        return lookup.get(provider.getPattern()).map(pattern -> ImmutableList.of((Object)pattern)).orElse(ImmutableList.of());
    }

    default public void addBannerPatternProviderTooltip(List<Component> tooltips) {
        tooltips.add(PATTERN_AVAILABLE_TOOLTIP_TEXT);
    }
}

