/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.item;

import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ItemDamageImmunity {
    private static final Map<Item, List<TagKey<DamageType>>> damageSourceImmunities = new HashMap<Item, List<TagKey<DamageType>>>();

    public static void registerImmunity(ItemLike itemConvertible, TagKey<DamageType> damageTypeTag) {
    }

    public static boolean isImmuneTo(ItemStack itemStack, DamageSource damageSource) {
        if (damageSource.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return false;
        }
        if (EnchantmentHelper.hasTag((ItemStack)itemStack, PastelEnchantmentTags.PREVENTS_ITEM_DAMAGE)) {
            return true;
        }
        Item item = itemStack.getItem();
        if (damageSourceImmunities.containsKey(item)) {
            for (TagKey<DamageType> type : damageSourceImmunities.get(item)) {
                if (!damageSource.is(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isImmuneTo(ItemStack itemStack, TagKey<DamageType> damageTypeTag) {
        Item item = itemStack.getItem();
        if (damageSourceImmunities.containsKey(item)) {
            for (TagKey<DamageType> type : damageSourceImmunities.get(item)) {
                if (!type.equals(damageTypeTag)) continue;
                return true;
            }
        }
        return false;
    }
}

