/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction;

import earth.terrarium.pastel.api.interaction.EntityColorProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class EntityColorProcessorRegistry {
    private static final Map<Supplier<EntityType<?>>, TriFunction<Entity, Optional<DyeColor>, Player, Boolean>> PROCESSOR = new HashMap();

    public static <E extends Entity> void register(Supplier<EntityType<E>> entityType, EntityColorProcessor<E> processor) {
        TriFunction ttt = (entity, dyeColor, player) -> processor.colorEntity((Object)entity, (Optional<DyeColor>)dyeColor, (Player)player);
        PROCESSOR.put(entityType::get, (TriFunction<Entity, Optional<DyeColor>, Player, Boolean>)ttt);
    }

    public static boolean colorEntity(Entity entity, Optional<DyeColor> dyeColor, @Nullable Player player) {
        @Nullable TriFunction colorProcessor = PROCESSOR.getOrDefault(entity.getType(), null);
        if (colorProcessor != null) {
            return (Boolean)colorProcessor.apply((Object)entity, dyeColor, (Object)player);
        }
        return false;
    }
}

